/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.RowData;
import java.util.ArrayList;
import java.util.List;

public class FieldFilterSelector {
    private final List<String> fieldExcludeList;

    FieldFilterSelector(List<String> fieldExcludeList) {
        this.fieldExcludeList = fieldExcludeList;
    }

    public FieldFilter selectFieldFilter(KeyspaceTable keyspaceTable) {
        ArrayList<Field> filteredFields = new ArrayList<Field>();
        for (String column : this.fieldExcludeList) {
            Field field = new Field(column);
            if (!field.keyspaceTable.equals(keyspaceTable)) continue;
            filteredFields.add(field);
        }
        if (filteredFields.size() > 0) {
            return rowData -> {
                RowData copy = rowData.copy();
                for (Field field : filteredFields) {
                    if (!copy.hasCell(field.column)) continue;
                    copy.removeCell(field.column);
                }
                return copy;
            };
        }
        return rowData -> rowData;
    }

    private static final class Field {
        final KeyspaceTable keyspaceTable;
        final String column;

        private Field(String fieldExcludeList) {
            String[] elements = fieldExcludeList.split("\\.", 3);
            String keyspace = elements[0];
            String table = elements[1];
            this.keyspaceTable = new KeyspaceTable(keyspace, table);
            this.column = elements[2];
        }
    }

    public static interface FieldFilter {
        public RowData apply(RowData var1);
    }
}

