/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class JoinGroupRequestData
implements ApiMessage {
    private String groupId;
    private int sessionTimeoutMs;
    private int rebalanceTimeoutMs;
    private String memberId;
    private String groupInstanceId;
    private String protocolType;
    private JoinGroupRequestProtocolCollection protocols;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The group identifier."), new Field("session_timeout_ms", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("member_id", Type.STRING, "The member id assigned by the group coordinator."), new Field("protocol_type", Type.STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", new ArrayOf(JoinGroupRequestProtocol.SCHEMA_0), "The list of protocols that the member supports."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;

    public JoinGroupRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public JoinGroupRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public JoinGroupRequestData() {
        this.groupId = "";
        this.sessionTimeoutMs = 0;
        this.rebalanceTimeoutMs = -1;
        this.memberId = "";
        this.groupInstanceId = null;
        this.protocolType = "";
        this.protocols = new JoinGroupRequestProtocolCollection(0);
    }

    @Override
    public short apiKey() {
        return 11;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        JoinGroupRequestProtocolCollection newCollection;
        int arrayLength;
        int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        this.sessionTimeoutMs = _readable.readInt();
        this.rebalanceTimeoutMs = _version >= 1 ? _readable.readInt() : -1;
        length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field memberId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field memberId had invalid length " + length);
        }
        this.memberId = _readable.readString(length);
        if (_version >= 5) {
            length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.groupInstanceId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                }
                this.groupInstanceId = _readable.readString(length);
            }
        } else {
            this.groupInstanceId = null;
        }
        length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field protocolType was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field protocolType had invalid length " + length);
        }
        this.protocolType = _readable.readString(length);
        if (_version >= 6) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field protocols was serialized as null");
            }
            newCollection = new JoinGroupRequestProtocolCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new JoinGroupRequestProtocol(_readable, _version));
            }
            this.protocols = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field protocols was serialized as null");
            }
            newCollection = new JoinGroupRequestProtocolCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new JoinGroupRequestProtocol(_readable, _version));
            }
            this.protocols = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.groupId);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.sessionTimeoutMs);
        if (_version >= 1) {
            _writable.writeInt(this.rebalanceTimeoutMs);
        }
        _stringBytes = _cache.getSerializedValue(this.memberId);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        if (_version >= 5) {
            if (this.groupInstanceId == null) {
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.groupInstanceId);
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
        } else if (this.groupInstanceId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + _version);
        }
        _stringBytes = _cache.getSerializedValue(this.protocolType);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(this.protocols.size() + 1);
            _stringBytes = this.protocols.iterator();
            while (_stringBytes.hasNext()) {
                JoinGroupRequestProtocol protocolsElement = (JoinGroupRequestProtocol)_stringBytes.next();
                protocolsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.protocols.size());
            _stringBytes = this.protocols.iterator();
            while (_stringBytes.hasNext()) {
                JoinGroupRequestProtocol protocolsElement = (JoinGroupRequestProtocol)_stringBytes.next();
                protocolsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 6) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.groupId = struct.getString("group_id");
        this.sessionTimeoutMs = struct.getInt("session_timeout_ms");
        this.rebalanceTimeoutMs = _version >= 1 ? struct.getInt("rebalance_timeout_ms") : -1;
        this.memberId = struct.getString("member_id");
        this.groupInstanceId = _version >= 5 ? struct.getString("group_instance_id") : null;
        this.protocolType = struct.getString("protocol_type");
        Object[] _nestedObjects = struct.getArray("protocols");
        this.protocols = new JoinGroupRequestProtocolCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.protocols.add(new JoinGroupRequestProtocol((Struct)nestedObject, _version));
        }
        if (_version >= 6 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 6) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("group_id", (Object)this.groupId);
        struct.set("session_timeout_ms", (Object)this.sessionTimeoutMs);
        if (_version >= 1) {
            struct.set("rebalance_timeout_ms", (Object)this.rebalanceTimeoutMs);
        }
        struct.set("member_id", (Object)this.memberId);
        if (_version >= 5) {
            struct.set("group_instance_id", (Object)this.groupInstanceId);
        } else if (this.groupInstanceId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + _version);
        }
        struct.set("protocol_type", (Object)this.protocolType);
        Struct[] _nestedObjects = new Struct[this.protocols.size()];
        int i = 0;
        for (JoinGroupRequestProtocol element : this.protocols) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("protocols", (Object)_nestedObjects);
        if (_version >= 6) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        _size += 4;
        if (_version >= 1) {
            _size += 4;
        }
        if ((_stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
            throw new RuntimeException("'memberId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.memberId, _stringBytes);
        _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        if (_version >= 5) {
            if (this.groupInstanceId == null) {
                _size = _version >= 6 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.groupInstanceId, _stringBytes);
                _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
        }
        if ((_stringBytes = this.protocolType.getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
            throw new RuntimeException("'protocolType' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.protocolType, _stringBytes);
        _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        int _arraySize = 0;
        _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.protocols.size() + 1)) : (_arraySize += 4);
        for (JoinGroupRequestProtocol protocolsElement : this.protocols) {
            _arraySize += protocolsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 6) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinGroupRequestData)) {
            return false;
        }
        JoinGroupRequestData other = (JoinGroupRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.sessionTimeoutMs != other.sessionTimeoutMs) {
            return false;
        }
        if (this.rebalanceTimeoutMs != other.rebalanceTimeoutMs) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId)) {
            return false;
        }
        if (this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType)) {
            return false;
        }
        return !(this.protocols == null ? other.protocols != null : !this.protocols.equals(other.protocols));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + this.sessionTimeoutMs;
        hashCode = 31 * hashCode + this.rebalanceTimeoutMs;
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
        hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
        hashCode = 31 * hashCode + (this.protocols == null ? 0 : this.protocols.hashCode());
        return hashCode;
    }

    @Override
    public JoinGroupRequestData duplicate() {
        JoinGroupRequestData _duplicate = new JoinGroupRequestData();
        _duplicate.groupId = this.groupId;
        _duplicate.sessionTimeoutMs = this.sessionTimeoutMs;
        _duplicate.rebalanceTimeoutMs = this.rebalanceTimeoutMs;
        _duplicate.memberId = this.memberId;
        _duplicate.groupInstanceId = this.groupInstanceId == null ? null : this.groupInstanceId;
        _duplicate.protocolType = this.protocolType;
        JoinGroupRequestProtocolCollection newProtocols = new JoinGroupRequestProtocolCollection(this.protocols.size());
        for (JoinGroupRequestProtocol _element : this.protocols) {
            newProtocols.add(_element.duplicate());
        }
        _duplicate.protocols = newProtocols;
        return _duplicate;
    }

    public String toString() {
        return "JoinGroupRequestData(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", sessionTimeoutMs=" + this.sessionTimeoutMs + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ", protocolType=" + (this.protocolType == null ? "null" : "'" + this.protocolType.toString() + "'") + ", protocols=" + MessageUtil.deepToString(this.protocols.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public String memberId() {
        return this.memberId;
    }

    public String groupInstanceId() {
        return this.groupInstanceId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public JoinGroupRequestProtocolCollection protocols() {
        return this.protocols;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public JoinGroupRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public JoinGroupRequestData setSessionTimeoutMs(int v) {
        this.sessionTimeoutMs = v;
        return this;
    }

    public JoinGroupRequestData setRebalanceTimeoutMs(int v) {
        this.rebalanceTimeoutMs = v;
        return this;
    }

    public JoinGroupRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public JoinGroupRequestData setGroupInstanceId(String v) {
        this.groupInstanceId = v;
        return this;
    }

    public JoinGroupRequestData setProtocolType(String v) {
        this.protocolType = v;
        return this;
    }

    public JoinGroupRequestData setProtocols(JoinGroupRequestProtocolCollection v) {
        this.protocols = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("group_id", Type.STRING, "The group identifier."), new Field("session_timeout_ms", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("rebalance_timeout_ms", Type.INT32, "The maximum time in milliseconds that the coordinator will wait for each member to rejoin when rebalancing the group."), new Field("member_id", Type.STRING, "The member id assigned by the group coordinator."), new Field("protocol_type", Type.STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", new ArrayOf(JoinGroupRequestProtocol.SCHEMA_0), "The list of protocols that the member supports."))));
        SCHEMA_5 = new Schema(new Field("group_id", Type.STRING, "The group identifier."), new Field("session_timeout_ms", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("rebalance_timeout_ms", Type.INT32, "The maximum time in milliseconds that the coordinator will wait for each member to rejoin when rebalancing the group."), new Field("member_id", Type.STRING, "The member id assigned by the group coordinator."), new Field("group_instance_id", Type.NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), new Field("protocol_type", Type.STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", new ArrayOf(JoinGroupRequestProtocol.SCHEMA_0), "The list of protocols that the member supports."));
        SCHEMA_7 = SCHEMA_6 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("session_timeout_ms", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("rebalance_timeout_ms", Type.INT32, "The maximum time in milliseconds that the coordinator will wait for each member to rejoin when rebalancing the group."), new Field("member_id", Type.COMPACT_STRING, "The member id assigned by the group coordinator."), new Field("group_instance_id", Type.COMPACT_NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), new Field("protocol_type", Type.COMPACT_STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", new CompactArrayOf(JoinGroupRequestProtocol.SCHEMA_6), "The list of protocols that the member supports."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class JoinGroupRequestProtocolCollection
    extends ImplicitLinkedHashMultiCollection<JoinGroupRequestProtocol> {
        public JoinGroupRequestProtocolCollection() {
        }

        public JoinGroupRequestProtocolCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public JoinGroupRequestProtocolCollection(Iterator<JoinGroupRequestProtocol> iterator) {
            super(iterator);
        }

        @Override
        public JoinGroupRequestProtocol find(String name) {
            JoinGroupRequestProtocol _key = new JoinGroupRequestProtocol();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<JoinGroupRequestProtocol> findAll(String name) {
            JoinGroupRequestProtocol _key = new JoinGroupRequestProtocol();
            _key.setName(name);
            return this.findAll(_key);
        }

        public JoinGroupRequestProtocolCollection duplicate() {
            JoinGroupRequestProtocolCollection _duplicate = new JoinGroupRequestProtocolCollection(this.size());
            for (JoinGroupRequestProtocol _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class JoinGroupRequestProtocol
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private byte[] metadata;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public JoinGroupRequestProtocol(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public JoinGroupRequestProtocol(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public JoinGroupRequestProtocol() {
            this.name = "";
            this.metadata = Bytes.EMPTY;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of JoinGroupRequestProtocol");
            }
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field metadata was serialized as null");
            }
            byte[] newBytes = new byte[length];
            _readable.readArray(newBytes);
            this.metadata = newBytes;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.metadata.length + 1);
            } else {
                _writable.writeInt(this.metadata.length);
            }
            _writable.writeByteArray(this.metadata);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of JoinGroupRequestProtocol");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            this.metadata = struct.getByteArray("metadata");
            if (_version >= 6 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of JoinGroupRequestProtocol");
            }
            TreeMap _taggedFields = null;
            if (_version >= 6) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.setByteArray("metadata", this.metadata);
            if (_version >= 6) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of JoinGroupRequestProtocol");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            int _bytesSize = this.metadata.length;
            _bytesSize = _version >= 6 ? (_bytesSize += ByteUtils.sizeOfUnsignedVarint(this.metadata.length + 1)) : (_bytesSize += 4);
            _size += _bytesSize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 6) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof JoinGroupRequestProtocol)) {
                return false;
            }
            JoinGroupRequestProtocol other = (JoinGroupRequestProtocol)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JoinGroupRequestProtocol)) {
                return false;
            }
            JoinGroupRequestProtocol other = (JoinGroupRequestProtocol)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return Arrays.equals(this.metadata, other.metadata);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public JoinGroupRequestProtocol duplicate() {
            JoinGroupRequestProtocol _duplicate = new JoinGroupRequestProtocol();
            _duplicate.name = this.name;
            _duplicate.metadata = MessageUtil.duplicate(this.metadata);
            return _duplicate;
        }

        public String toString() {
            return "JoinGroupRequestProtocol(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", metadata=" + Arrays.toString(this.metadata) + ")";
        }

        public String name() {
            return this.name;
        }

        public byte[] metadata() {
            return this.metadata;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public JoinGroupRequestProtocol setName(String v) {
            this.name = v;
            return this;
        }

        public JoinGroupRequestProtocol setMetadata(byte[] v) {
            this.metadata = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The protocol name."), new Field("metadata", Type.BYTES, "The protocol metadata."))))));
            SCHEMA_7 = SCHEMA_6 = new Schema(new Field("name", Type.COMPACT_STRING, "The protocol name."), new Field("metadata", Type.COMPACT_BYTES, "The protocol metadata."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

