/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.WithOnlyQueriedData;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowIterators {
    private static final Logger logger = LoggerFactory.getLogger(RowIterators.class);

    private RowIterators() {
    }

    public static void digest(RowIterator iterator, MessageDigest digest, MessageDigest altDigest, Set<ByteBuffer> columnsToExclude) {
        digest.update(iterator.partitionKey().getKey().duplicate());
        iterator.columns().regulars.digest(digest);
        iterator.columns().statics.digest(digest);
        FBUtilities.updateWithBoolean(digest, iterator.isReverseOrder());
        iterator.staticRow().digest(digest);
        if (altDigest != null) {
            altDigest.update(iterator.partitionKey().getKey().duplicate());
            iterator.columns().regulars.digest(altDigest, columnsToExclude);
            iterator.columns().statics.digest(altDigest, columnsToExclude);
            FBUtilities.updateWithBoolean(altDigest, iterator.isReverseOrder());
            iterator.staticRow().digest(altDigest, columnsToExclude);
        }
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            row.digest(digest);
            if (altDigest == null) continue;
            row.digest(altDigest, columnsToExclude);
        }
    }

    public static RowIterator withOnlyQueriedData(RowIterator iterator, ColumnFilter filter) {
        if (filter.allFetchedColumnsAreQueried()) {
            return iterator;
        }
        return Transformation.apply(iterator, new WithOnlyQueriedData(filter));
    }

    public static RowIterator loggingIterator(RowIterator iterator, final String id) {
        final CFMetaData metadata = iterator.metadata();
        logger.info("[{}] Logging iterator on {}.{}, partition key={}, reversed={}", new Object[]{id, metadata.ksName, metadata.cfName, metadata.getKeyValidator().getString(iterator.partitionKey().getKey()), iterator.isReverseOrder()});
        class Log
        extends Transformation {
            Log() {
            }

            @Override
            public Row applyToStatic(Row row) {
                if (!row.isEmpty()) {
                    logger.info("[{}] {}", (Object)id, (Object)row.toString(metadata));
                }
                return row;
            }

            @Override
            public Row applyToRow(Row row) {
                logger.info("[{}] {}", (Object)id, (Object)row.toString(metadata));
                return row;
            }
        }
        return Transformation.apply(iterator, new Log());
    }
}

