/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.LogicalTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public class SetTypeDeserializer
extends CollectionTypeDeserializer<SetType<?>> {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        Set deserializedSet = (Set)super.deserialize(abstractType, bb);
        List<Object> deserializedList = this.convertDeserializedElementsIfNecessary(abstractType, deserializedSet);
        return Values.convertToList((Schema)this.getSchemaBuilder(abstractType).build(), deserializedList);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        SetType setType = (SetType)abstractType;
        AbstractType elementsType = setType.getElementsType();
        Schema innerSchema = CassandraTypeDeserializer.getSchemaBuilder(elementsType).build();
        return SchemaBuilder.array((Schema)innerSchema).optional();
    }

    @Override
    public Object deserialize(SetType<?> setType, ComplexColumnData ccd) {
        List bbList = setType.serializedValues(ccd.iterator());
        AbstractType elementsType = setType.getElementsType();
        HashSet<Object> deserializedSet = new HashSet<Object>();
        for (ByteBuffer bb : bbList) {
            deserializedSet.add(CassandraTypeDeserializer.deserialize(elementsType, bb));
        }
        ArrayList deserializedList = new ArrayList(deserializedSet);
        return Values.convertToList((Schema)this.getSchemaBuilder((AbstractType<?>)setType).build(), deserializedList);
    }

    private List<Object> convertDeserializedElementsIfNecessary(AbstractType<?> abstractType, Set<?> deserializedSet) {
        AbstractType elementsType = ((SetType)abstractType).getElementsType();
        TypeDeserializer elementsTypeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(elementsType);
        if (elementsTypeDeserializer instanceof LogicalTypeDeserializer) {
            ArrayList<Object> convertedDeserializedList = new ArrayList<Object>();
            for (Object element : deserializedSet) {
                Object convertedValue = ((LogicalTypeDeserializer)elementsTypeDeserializer).convertDeserializedValue(elementsType, element);
                convertedDeserializedList.add(convertedValue);
            }
            return convertedDeserializedList;
        }
        return new ArrayList<Object>(deserializedSet);
    }
}

