/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.config.Configuration;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class CassandraConnectorConfigTest {
    @Test
    public void testConfigs() {
        String connectorName = "test_connector";
        CassandraConnectorConfig config = this.buildTaskConfig(CassandraConnectorConfig.CONNECTOR_NAME.name(), connectorName);
        Assert.assertEquals((Object)connectorName, (Object)config.connectorName());
        String kafkaTopicPrefix = "test_prefix";
        config = this.buildTaskConfig(CassandraConnectorConfig.KAFKA_TOPIC_PREFIX.name(), kafkaTopicPrefix);
        Assert.assertEquals((Object)kafkaTopicPrefix, (Object)config.kafkaTopicPrefix());
        String snapshotConsistency = "ALL";
        config = this.buildTaskConfig(CassandraConnectorConfig.SNAPSHOT_CONSISTENCY.name(), snapshotConsistency);
        Assert.assertEquals((Object)snapshotConsistency, (Object)config.snapshotConsistencyLevel().name().toUpperCase());
        int port = 1234;
        config = this.buildTaskConfig(CassandraConnectorConfig.HTTP_PORT.name(), String.valueOf(port));
        Assert.assertEquals((long)port, (long)config.httpPort());
        String cassandraConfig = "cassandra-unit.yaml";
        config = this.buildTaskConfig(CassandraConnectorConfig.CASSANDRA_CONFIG.name(), cassandraConfig);
        Assert.assertEquals((Object)cassandraConfig, (Object)config.cassandraConfig());
        String cassandraHosts = "127.0.0.1,127.0.0.2";
        config = this.buildTaskConfig(CassandraConnectorConfig.CASSANDRA_HOSTS.name(), cassandraHosts);
        Assert.assertArrayEquals((Object[])cassandraHosts.split(","), (Object[])config.cassandraHosts());
        int cassandraPort = 9412;
        config = this.buildTaskConfig(CassandraConnectorConfig.CASSANDRA_PORT.name(), String.valueOf(cassandraPort));
        Assert.assertEquals((long)cassandraPort, (long)config.cassandraPort());
        String cassandraUsername = "test_user";
        config = this.buildTaskConfig(CassandraConnectorConfig.CASSANDRA_USERNAME.name(), cassandraUsername);
        Assert.assertEquals((Object)cassandraUsername, (Object)config.cassandraUsername());
        String cassandraPassword = "test_pw";
        config = this.buildTaskConfig(CassandraConnectorConfig.CASSANDRA_PASSWORD.name(), cassandraPassword);
        Assert.assertEquals((Object)cassandraPassword, (Object)config.cassandraPassword());
        config = this.buildTaskConfig(CassandraConnectorConfig.CASSANDRA_SSL_ENABLED.name(), "true");
        Assert.assertTrue((boolean)config.cassandraSslEnabled());
        String cassandraSslConfigPath = "/some/path/";
        config = this.buildTaskConfig(CassandraConnectorConfig.CASSANDRA_SSL_CONFIG_PATH.name(), cassandraSslConfigPath);
        Assert.assertEquals((Object)cassandraSslConfigPath, (Object)config.cassandraSslConfigPath());
        String kafkaServers = "host1,host2,host3";
        config = this.buildTaskConfig("kafka.producer.bootstrap.servers", kafkaServers);
        Assert.assertEquals((Object)kafkaServers, (Object)config.getKafkaConfigs().getProperty("bootstrap.servers"));
        String schemaRegistry = "schema-registry-host";
        config = this.buildTaskConfig("kafka.producer.schema.registry", schemaRegistry);
        Assert.assertEquals((Object)schemaRegistry, (Object)config.getKafkaConfigs().getProperty("schema.registry"));
        String offsetBackingStore = "/some/offset/backing/store/";
        config = this.buildTaskConfig(CassandraConnectorConfig.OFFSET_BACKING_STORE_DIR.name(), offsetBackingStore);
        Assert.assertEquals((Object)offsetBackingStore, (Object)config.offsetBackingStoreDir());
        int offsetFlushIntervalMs = 1234;
        config = this.buildTaskConfig(CassandraConnectorConfig.OFFSET_FLUSH_INTERVAL_MS.name(), String.valueOf(offsetFlushIntervalMs));
        Assert.assertEquals((long)offsetFlushIntervalMs, (long)config.offsetFlushIntervalMs().toMillis());
        int offsetMaxFlushSize = 200;
        config = this.buildTaskConfig(CassandraConnectorConfig.MAX_OFFSET_FLUSH_SIZE.name(), String.valueOf(offsetMaxFlushSize));
        Assert.assertEquals((long)offsetMaxFlushSize, (long)config.maxOffsetFlushSize());
        int maxQueueSize = 500;
        config = this.buildTaskConfig(CassandraConnectorConfig.MAX_QUEUE_SIZE.name(), String.valueOf(maxQueueSize));
        Assert.assertEquals((long)maxQueueSize, (long)config.maxQueueSize());
        int maxBatchSize = 500;
        config = this.buildTaskConfig(CassandraConnectorConfig.MAX_BATCH_SIZE.name(), String.valueOf(maxBatchSize));
        Assert.assertEquals((long)maxBatchSize, (long)config.maxBatchSize());
        int pollIntervalMs = 500;
        config = this.buildTaskConfig(CassandraConnectorConfig.POLL_INTERVAL_MS.name(), String.valueOf(pollIntervalMs));
        Assert.assertEquals((long)pollIntervalMs, (long)config.pollIntervalMs().toMillis());
        int schemaPollIntervalMs = 500;
        config = this.buildTaskConfig(CassandraConnectorConfig.SCHEMA_POLL_INTERVAL_MS.name(), String.valueOf(schemaPollIntervalMs));
        Assert.assertEquals((long)schemaPollIntervalMs, (long)config.schemaPollIntervalMs().toMillis());
        int cdcDirPollIntervalMs = 500;
        config = this.buildTaskConfig(CassandraConnectorConfig.CDC_DIR_POLL_INTERVAL_MS.name(), String.valueOf(cdcDirPollIntervalMs));
        Assert.assertEquals((long)cdcDirPollIntervalMs, (long)config.cdcDirPollIntervalMs().toMillis());
        int snapshotPollIntervalMs = 500;
        config = this.buildTaskConfig(CassandraConnectorConfig.SNAPSHOT_POLL_INTERVAL_MS.name(), String.valueOf(snapshotPollIntervalMs));
        Assert.assertEquals((long)snapshotPollIntervalMs, (long)config.snapshotPollIntervalMs().toMillis());
        String fieldExcludeList = "keyspace1.table1.column1,keyspace1.table1.column2";
        List<String> fieldExcludeListExpected = Arrays.asList(fieldExcludeList.split(","));
        config = this.buildTaskConfig(CassandraConnectorConfig.FIELD_EXCLUDE_LIST.name(), fieldExcludeList);
        Assert.assertEquals(fieldExcludeListExpected, (Object)config.fieldExcludeList());
        config = this.buildTaskConfig(CassandraConnectorConfig.FIELD_BLACKLIST.name(), fieldExcludeList);
        Assert.assertEquals(fieldExcludeListExpected, (Object)config.fieldExcludeList());
        config = this.buildTaskConfig(CassandraConnectorConfig.TOMBSTONES_ON_DELETE.name(), "true");
        Assert.assertTrue((boolean)config.tombstonesOnDelete());
        String snapshotMode = "always";
        config = this.buildTaskConfig(CassandraConnectorConfig.SNAPSHOT_MODE.name(), snapshotMode);
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.ALWAYS, (Object)config.snapshotMode());
        String commitLogDir = "/foo/bar";
        config = this.buildTaskConfig(CassandraConnectorConfig.COMMIT_LOG_RELOCATION_DIR.name(), commitLogDir);
        Assert.assertEquals((Object)commitLogDir, (Object)config.commitLogRelocationDir());
        config = this.buildTaskConfig(CassandraConnectorConfig.COMMIT_LOG_POST_PROCESSING_ENABLED.name(), "false");
        Assert.assertEquals((Object)false, (Object)config.postProcessEnabled());
        config = this.buildTaskConfig(CassandraConnectorConfig.COMMIT_LOG_ERROR_REPROCESSING_ENABLED.name(), "true");
        Assert.assertTrue((boolean)config.errorCommitLogReprocessEnabled());
        String transferClazz = "io.debezium.connector.cassandra.BlackHoleCommitLogTransfer";
        config = this.buildTaskConfig(CassandraConnectorConfig.COMMIT_LOG_TRANSFER_CLASS.name(), transferClazz);
        Assert.assertEquals((Object)transferClazz, (Object)config.getCommitLogTransfer().getClass().getName());
        String keyConverterClass = "io.confluent.connect.avro.AvroConverter";
        HashMap<String, Object> keyConverterConfigs = new HashMap<String, Object>();
        keyConverterConfigs.put(CassandraConnectorConfig.KEY_CONVERTER_CLASS_CONFIG.name(), keyConverterClass);
        keyConverterConfigs.put("key.converter.schema.registry.url", "http://localhost:8081");
        config = this.buildTaskConfigs(keyConverterConfigs);
        Assert.assertEquals((Object)keyConverterClass, (Object)config.getKeyConverter().getClass().getName());
        String valueConverterClass = "org.apache.kafka.connect.json.JsonConverter";
        config = this.buildTaskConfig(CassandraConnectorConfig.VALUE_CONVERTER_CLASS_CONFIG.name(), valueConverterClass);
        Assert.assertEquals((Object)valueConverterClass, (Object)config.getValueConverter().getClass().getName());
    }

    private CassandraConnectorConfig buildTaskConfigs(HashMap<String, Object> map) {
        return new CassandraConnectorConfig(Configuration.from(map));
    }

    private CassandraConnectorConfig buildTaskConfig(String key, Object value) {
        Properties props = new Properties();
        props.put(key, value);
        return new CassandraConnectorConfig(Configuration.from((Properties)props));
    }

    @Test
    public void testDefaultConfigs() {
        Properties props = new Properties();
        CassandraConnectorConfig config = new CassandraConnectorConfig(Configuration.from((Properties)props));
        Assert.assertEquals((Object)"QUORUM", (Object)config.snapshotConsistencyLevel().name().toUpperCase());
        Assert.assertEquals((long)8000L, (long)config.httpPort());
        Assert.assertArrayEquals((Object[])"localhost".split(","), (Object[])config.cassandraHosts());
        Assert.assertEquals((long)9042L, (long)config.cassandraPort());
        Assert.assertEquals((long)8192L, (long)config.maxQueueSize());
        Assert.assertEquals((long)2048L, (long)config.maxBatchSize());
        Assert.assertEquals((long)1000L, (long)config.pollIntervalMs().toMillis());
        Assert.assertEquals((long)100L, (long)config.maxOffsetFlushSize());
        Assert.assertEquals((long)0L, (long)config.offsetFlushIntervalMs().toMillis());
        Assert.assertEquals((long)10000L, (long)config.schemaPollIntervalMs().toMillis());
        Assert.assertEquals((long)10000L, (long)config.cdcDirPollIntervalMs().toMillis());
        Assert.assertEquals((long)10000L, (long)config.snapshotPollIntervalMs().toMillis());
        Assert.assertEquals((Object)true, (Object)config.postProcessEnabled());
        Assert.assertEquals((Object)false, (Object)config.errorCommitLogReprocessEnabled());
        Assert.assertEquals((Object)"io.debezium.connector.cassandra.BlackHoleCommitLogTransfer", (Object)config.getCommitLogTransfer().getClass().getName());
        Assert.assertFalse((boolean)config.cassandraSslEnabled());
        Assert.assertFalse((boolean)config.tombstonesOnDelete());
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.INITIAL, (Object)config.snapshotMode());
        Assert.assertEquals((Object)false, (Object)config.latestCommitLogOnly());
    }

    @Test
    public void testSnapshotMode() {
        String mode = "initial";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.INITIAL, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = "INITIAL";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.INITIAL, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = "Initial";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.INITIAL, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = "always";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.ALWAYS, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = "never";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.NEVER, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = null;
        Assert.assertFalse((boolean)CassandraConnectorConfig.SnapshotMode.fromText((String)mode).isPresent());
        mode = "";
        Assert.assertFalse((boolean)CassandraConnectorConfig.SnapshotMode.fromText((String)mode).isPresent());
        mode = "invalid";
        Assert.assertFalse((boolean)CassandraConnectorConfig.SnapshotMode.fromText((String)mode).isPresent());
    }
}

