/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeKafkaSchemaBuilders;
import io.debezium.connector.cassandra.transforms.type.deserializer.LogicalTypeDeserializer;
import io.debezium.time.NanoDuration;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.kafka.connect.data.SchemaBuilder;

public class DurationTypeDeserializer
extends LogicalTypeDeserializer {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        Object value = super.deserialize(abstractType, bb);
        return this.convertDeserializedValue(abstractType, value);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        return CassandraTypeKafkaSchemaBuilders.DURATION_TYPE;
    }

    @Override
    public Object convertDeserializedValue(AbstractType<?> abstractType, Object value) {
        Duration duration = (Duration)value;
        int months = duration.getMonths();
        int days = duration.getDays();
        long nanoSec = duration.getNanoseconds();
        return NanoDuration.durationNanos((int)0, (int)months, (int)days, (int)0, (int)0, (long)0L, (long)nanoSec);
    }
}

