/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.utils;

import io.debezium.connector.cassandra.CommitLogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public class CommitLogUtilTest {
    @Test
    public void testMoveCommitLog() throws IOException {
        Path fromDr = Files.createTempDirectory("from", new FileAttribute[0]);
        Path toDir = Files.createTempDirectory("to", new FileAttribute[0]);
        Assert.assertTrue((boolean)new File(fromDr.toString(), "CommitLog-6-1.log").createNewFile());
        Assert.assertTrue((boolean)new File(fromDr.toString(), "Not-CommitLog-6-1.log").createNewFile());
        for (File file : Objects.requireNonNull(fromDr.toFile().listFiles())) {
            CommitLogUtil.moveCommitLog((File)file, (Path)toDir);
        }
        Assert.assertEquals((long)1L, (long)Objects.requireNonNull(toDir.toFile().listFiles()).length);
        Assert.assertEquals((long)1L, (long)Objects.requireNonNull(fromDr.toFile().listFiles()).length);
        Assert.assertEquals((Object)new File(toDir.toFile(), "CommitLog-6-1.log"), (Object)Objects.requireNonNull(toDir.toFile().listFiles())[0]);
        Assert.assertEquals((Object)new File(fromDr.toFile(), "Not-CommitLog-6-1.log"), (Object)Objects.requireNonNull(fromDr.toFile().listFiles())[0]);
    }

    @Test
    public void testDeleteCommitLog() throws IOException {
        Path dir = Files.createTempDirectory("temp", new FileAttribute[0]);
        File commitLog = new File(dir.toString(), "CommitLog-6-1.log");
        File notCommitLog = new File(dir.toString(), "Not-CommitLog-6-1.log");
        Assert.assertTrue((boolean)commitLog.createNewFile());
        Assert.assertTrue((boolean)notCommitLog.createNewFile());
        CommitLogUtil.deleteCommitLog((File)commitLog);
        CommitLogUtil.deleteCommitLog((File)notCommitLog);
        Assert.assertFalse((boolean)commitLog.exists());
        Assert.assertTrue((boolean)notCommitLog.exists());
    }

    @Test
    public void testGetCommitLogs() throws IOException {
        Path dir = Files.createTempDirectory("temp", new FileAttribute[0]);
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                Assert.assertTrue((boolean)new File(dir.toString(), "CommitLog-6-" + i + ".log").createNewFile());
                continue;
            }
            Assert.assertTrue((boolean)new File(dir.toString(), "Not-CommitLog-6-" + i + ".log").createNewFile());
        }
        Assert.assertEquals((long)5L, (long)CommitLogUtil.getCommitLogs((File)dir.toFile()).length);
    }

    @Test
    public void testCompareCommitLogs() {
        String commit1 = "CommitLog-6-1.log";
        String commit2 = "CommitLog-6-2.log";
        String commit3 = "CommitLog-6-0.log";
        String commit4 = "CommitLog-6-1.log";
        Assert.assertEquals((long)-1L, (long)CommitLogUtil.compareCommitLogs((String)commit1, (String)commit2));
        Assert.assertEquals((long)1L, (long)CommitLogUtil.compareCommitLogs((String)commit1, (String)commit3));
        Assert.assertEquals((long)0L, (long)CommitLogUtil.compareCommitLogs((String)commit1, (String)commit4));
    }
}

