/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.ChangeRecord;
import io.debezium.connector.cassandra.FileOffsetWriter;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.OffsetPosition;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.RowData;
import io.debezium.connector.cassandra.SourceInfo;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import io.debezium.time.Conversions;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.kafka.connect.data.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileOffsetWriterTest {
    private Path offsetDir;
    private OffsetWriter offsetWriter;
    private Properties snapshotProps;
    private Properties commitLogProps;

    @Before
    public void setUp() throws IOException {
        this.offsetDir = Files.createTempDirectory("offset", new FileAttribute[0]);
        this.offsetWriter = new FileOffsetWriter(this.offsetDir.toAbsolutePath().toString());
        this.snapshotProps = new Properties();
        this.commitLogProps = new Properties();
    }

    @Test
    public void testMarkOffset() {
        ChangeRecord snapshotRecord = this.generateRecord(true, true, new OffsetPosition("", -1), new KeyspaceTable("test_keyspace", "test_table"));
        ChangeRecord commitLogRecord = this.generateRecord(true, false, new OffsetPosition("CommitLog-6-12345.log", 100), new KeyspaceTable("test_keyspace", "test_table"));
        ChangeRecord commitLogRecordDupe = this.generateRecord(true, false, new OffsetPosition("CommitLog-6-12345.log", 100), new KeyspaceTable("test_keyspace", "test_table"));
        ChangeRecord commitLogRecordOlderLog = this.generateRecord(true, false, new OffsetPosition("CommitLog-6-12344.log", 101), new KeyspaceTable("test_keyspace", "test_table"));
        ChangeRecord commitLogRecordDiffTable = this.generateRecord(true, false, new OffsetPosition("CommitLog-6-12345.log", 100), new KeyspaceTable("test_keyspace", "test_another_table"));
        Assert.assertFalse((boolean)this.isProcessed(snapshotRecord));
        this.process(snapshotRecord);
        Assert.assertTrue((boolean)this.isProcessed(snapshotRecord));
        Assert.assertFalse((boolean)this.isProcessed(commitLogRecord));
        this.process(commitLogRecord);
        Assert.assertTrue((boolean)this.isProcessed(commitLogRecord));
        Assert.assertTrue((boolean)this.isProcessed(commitLogRecordDupe));
        this.process(commitLogRecordDupe);
        Assert.assertTrue((boolean)this.isProcessed(commitLogRecordDupe));
        Assert.assertTrue((boolean)this.isProcessed(commitLogRecordOlderLog));
        this.process(commitLogRecordOlderLog);
        Assert.assertTrue((boolean)this.isProcessed(commitLogRecordOlderLog));
        Assert.assertTrue((boolean)this.isProcessed(commitLogRecord));
        Assert.assertFalse((boolean)this.isProcessed(commitLogRecordDiffTable));
        this.process(commitLogRecordDiffTable);
        Assert.assertTrue((boolean)this.isProcessed(commitLogRecordDiffTable));
    }

    @Test
    public void testFlush() throws IOException {
        this.offsetWriter.flush();
        try (FileInputStream fis = new FileInputStream(this.offsetDir.toString() + "/" + "snapshot_offset.properties");){
            this.snapshotProps.load(fis);
        }
        fis = new FileInputStream(this.offsetDir.toString() + "/" + "commitlog_offset.properties");
        var2_2 = null;
        try {
            this.commitLogProps.load(fis);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (fis != null) {
                if (var2_2 != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    fis.close();
                }
            }
        }
        Assert.assertEquals((long)0L, (long)this.snapshotProps.size());
        Assert.assertEquals((long)0L, (long)this.commitLogProps.size());
        ChangeRecord snapshotRecord = this.generateRecord(true, true, new OffsetPosition("", -1), new KeyspaceTable("test_keyspace", "test_table"));
        ChangeRecord commitLogRecord = this.generateRecord(true, false, new OffsetPosition("CommitLog-6-12345.log", 100), new KeyspaceTable("test_keyspace", "test_table"));
        ChangeRecord commitLogRecordDiffTable = this.generateRecord(true, false, new OffsetPosition("CommitLog-6-12345.log", 100), new KeyspaceTable("test_keyspace", "test_another_table"));
        this.process(snapshotRecord);
        this.process(commitLogRecord);
        this.process(commitLogRecordDiffTable);
        this.offsetWriter.flush();
        try (FileInputStream fis = new FileInputStream(this.offsetDir.toString() + "/" + "snapshot_offset.properties");){
            this.snapshotProps.load(fis);
        }
        fis = new FileInputStream(this.offsetDir.toString() + "/" + "commitlog_offset.properties");
        var5_11 = null;
        try {
            this.commitLogProps.load(fis);
        }
        catch (Throwable throwable) {
            var5_11 = throwable;
            throw throwable;
        }
        finally {
            if (fis != null) {
                if (var5_11 != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        var5_11.addSuppressed(throwable);
                    }
                } else {
                    fis.close();
                }
            }
        }
        Assert.assertEquals((long)1L, (long)this.snapshotProps.size());
        Assert.assertEquals((long)2L, (long)this.commitLogProps.size());
        Assert.assertEquals((Object)OffsetPosition.defaultOffsetPosition().serialize(), (Object)this.snapshotProps.getProperty(new KeyspaceTable("test_keyspace", "test_table").name()));
        Assert.assertEquals((Object)new OffsetPosition("CommitLog-6-12345.log", 100).serialize(), (Object)this.commitLogProps.getProperty(new KeyspaceTable("test_keyspace", "test_table").name()));
        Assert.assertEquals((Object)new OffsetPosition("CommitLog-6-12345.log", 100).serialize(), (Object)this.commitLogProps.getProperty(new KeyspaceTable("test_keyspace", "test_another_table").name()));
    }

    @Test(expected=CassandraConnectorTaskException.class)
    public void testTwoFileWriterCannotCoexist() throws IOException {
        new FileOffsetWriter(this.offsetDir.toAbsolutePath().toString());
    }

    private ChangeRecord generateRecord(boolean markOffset, boolean isSnapshot, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable) {
        CassandraConnectorConfig config = new CassandraConnectorConfig(Configuration.from((Properties)new Properties()));
        SourceInfo sourceInfo = new SourceInfo((CommonConnectorConfig)config, "test-cluster", offsetPosition, keyspaceTable, isSnapshot, Conversions.toInstantFromMicros((long)(System.currentTimeMillis() * 1000L)));
        return new ChangeRecord(sourceInfo, new RowData(), Schema.INT32_SCHEMA, Schema.INT32_SCHEMA, Record.Operation.INSERT, markOffset);
    }

    private boolean isProcessed(ChangeRecord record) {
        return this.offsetWriter.isOffsetProcessed(record.getSource().keyspaceTable.name(), record.getSource().offsetPosition.serialize(), record.getSource().snapshot);
    }

    private void process(ChangeRecord record) {
        this.offsetWriter.markOffset(record.getSource().keyspaceTable.name(), record.getSource().offsetPosition.serialize(), record.getSource().snapshot);
    }
}

