/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public class SetTypeDeserializer
extends CollectionTypeDeserializer<SetType<?>> {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        Set deserializedSet = (Set)super.deserialize(abstractType, bb);
        ArrayList deserializedList = new ArrayList(deserializedSet);
        return Values.convertToList((Schema)this.getSchemaBuilder(abstractType).build(), deserializedList);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        SetType listType = (SetType)abstractType;
        AbstractType elementsType = listType.getElementsType();
        Schema innerSchema = CassandraTypeDeserializer.getSchemaBuilder(elementsType).build();
        return SchemaBuilder.array((Schema)innerSchema).optional();
    }

    @Override
    public Object deserialize(SetType<?> collectionType, ComplexColumnData ccd) {
        List bbList = collectionType.serializedValues(ccd.iterator());
        AbstractType innerType = collectionType.getElementsType();
        HashSet<Object> deserializedSet = new HashSet<Object>();
        for (ByteBuffer bb : bbList) {
            deserializedSet.add(super.deserialize(innerType, bb));
        }
        ArrayList deserializedList = new ArrayList(deserializedSet);
        return Values.convertToList((Schema)this.getSchemaBuilder((AbstractType<?>)collectionType).build(), deserializedList);
    }
}

