/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public class ListTypeDeserializer
extends CollectionTypeDeserializer<ListType<?>> {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        List deserializedList = (List)super.deserialize(abstractType, bb);
        return Values.convertToList((Schema)this.getSchemaBuilder(abstractType).build(), (Object)deserializedList);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        ListType listType = (ListType)abstractType;
        AbstractType elementsType = listType.getElementsType();
        Schema innerSchema = CassandraTypeDeserializer.getSchemaBuilder(elementsType).build();
        return SchemaBuilder.array((Schema)innerSchema).optional();
    }

    @Override
    public Object deserialize(ListType<?> collectionType, ComplexColumnData ccd) {
        List bbList = collectionType.serializedValues(ccd.iterator());
        AbstractType innerType = collectionType.getElementsType();
        ArrayList<Object> deserializedList = new ArrayList<Object>(bbList.size());
        for (ByteBuffer bb : bbList) {
            deserializedList.add(super.deserialize(innerType, bb));
        }
        return Values.convertToList((Schema)this.getSchemaBuilder((AbstractType<?>)collectionType).build(), deserializedList);
    }
}

