/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public class MapTypeDeserializer
extends CollectionTypeDeserializer<MapType<?, ?>> {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        Map deserializedMap = (Map)super.deserialize(abstractType, bb);
        return Values.convertToMap((Schema)this.getSchemaBuilder(abstractType).build(), (Object)deserializedMap);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        MapType mapType = (MapType)abstractType;
        AbstractType keysType = mapType.getKeysType();
        AbstractType valuesType = mapType.getValuesType();
        Schema keySchema = CassandraTypeDeserializer.getSchemaBuilder(keysType).build();
        Schema valuesSchema = CassandraTypeDeserializer.getSchemaBuilder(valuesType).build();
        return SchemaBuilder.map((Schema)keySchema, (Schema)valuesSchema).optional();
    }

    @Override
    public Object deserialize(MapType<?, ?> collectionType, ComplexColumnData ccd) {
        List bbList = collectionType.serializedValues(ccd.iterator());
        AbstractType keyType = collectionType.getKeysType();
        AbstractType valueType = collectionType.getValuesType();
        HashMap<Object, Object> deserializedMap = new HashMap<Object, Object>();
        int i = 0;
        while (i < bbList.size()) {
            ByteBuffer kbb = (ByteBuffer)bbList.get(i++);
            ByteBuffer vbb = (ByteBuffer)bbList.get(i++);
            deserializedMap.put(super.deserialize(keyType, kbb), super.deserialize(valueType, vbb));
        }
        return Values.convertToMap((Schema)this.getSchemaBuilder((AbstractType<?>)collectionType).build(), deserializedMap);
    }
}

