/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import io.debezium.connector.cassandra.CassandraConnectorTask;
import java.util.concurrent.atomic.AtomicLong;

public class CommitLogProcessorMetrics {
    private String commitLogFilename = null;
    private AtomicLong commitLogPosition = new AtomicLong(-1L);
    private Counter numberOfProcessedMutations;
    private Counter numberOfUnrecoverableErrors;

    public void registerMetrics() {
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("commitlog-filename", (Metric)((Gauge)this::getCommitLogFilename));
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("commitlog-position", (Metric)((Gauge)this::getCommitLogPosition));
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("number-of-processed-mutations", (Metric)new Counter());
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("number-of-unrecoverable-errors", (Metric)new Counter());
    }

    public void unregisterMetrics() {
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("commitlog-filename");
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("commitlog-position");
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("number-of-processed-mutations");
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("number-of-unrecoverable-errors");
    }

    public void onSuccess() {
        if (this.numberOfProcessedMutations == null) {
            this.numberOfProcessedMutations = CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.counter("number-of-processed-mutations");
        }
        this.numberOfProcessedMutations.inc();
    }

    public void onUnrecoverableError() {
        if (this.numberOfUnrecoverableErrors == null) {
            this.numberOfUnrecoverableErrors = CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.counter("number-of-unrecoverable-errors");
        }
        this.numberOfUnrecoverableErrors.inc();
    }

    public String getCommitLogFilename() {
        return this.commitLogFilename;
    }

    public long getCommitLogPosition() {
        return this.commitLogPosition.get();
    }

    public void setCommitLogFilename(String name) {
        this.commitLogFilename = name;
        this.setCommitLogPosition(-1L);
    }

    public void setCommitLogPosition(long pos) {
        this.commitLogPosition.set(pos);
    }
}

