/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CassandraTypeConverterTest {
    @Test
    public void testAscii() {
        DataType asciiType = DataType.ascii();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)asciiType);
        AsciiType expectedType = AsciiType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testBlob() {
        DataType blobType = DataType.blob();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)blobType);
        BytesType expectedType = BytesType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testBigInt() {
        DataType bigIntType = DataType.bigint();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)bigIntType);
        LongType expectedType = LongType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testBoolean() {
        DataType booleanType = DataType.cboolean();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)booleanType);
        BooleanType expectedType = BooleanType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testCounter() {
        DataType counterType = DataType.counter();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)counterType);
        CounterColumnType expectedType = CounterColumnType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testDate() {
        DataType dateType = DataType.date();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)dateType);
        SimpleDateType expectedType = SimpleDateType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testDecimal() {
        DataType decimalType = DataType.decimal();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)decimalType);
        DecimalType expectedType = DecimalType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testDouble() {
        DataType doubleType = DataType.cdouble();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)doubleType);
        DoubleType expectedType = DoubleType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testDuration() {
        DataType durationType = DataType.duration();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)durationType);
        DurationType expectedType = DurationType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testFloat() {
        DataType floatType = DataType.cfloat();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)floatType);
        FloatType expectedType = FloatType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testInet() {
        DataType inetType = DataType.inet();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)inetType);
        InetAddressType expectedType = InetAddressType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testInt() {
        DataType intType = DataType.cint();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)intType);
        Int32Type expectedType = Int32Type.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testList() {
        DataType.CollectionType listType = DataType.list((DataType)DataType.cint(), (boolean)false);
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)listType);
        ListType expectedType = ListType.getInstance((AbstractType)Int32Type.instance, (boolean)true);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        listType = DataType.list((DataType)DataType.cint(), (boolean)true);
        convertedType = CassandraTypeConverter.convert((DataType)listType);
        expectedType = ListType.getInstance((AbstractType)Int32Type.instance, (boolean)false);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        Assert.assertTrue((String)"Expected convertedType to be frozen", (boolean)convertedType.isFrozenCollection());
    }

    @Test
    public void testMap() {
        DataType.CollectionType mapType = DataType.map((DataType)DataType.ascii(), (DataType)DataType.cdouble());
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)mapType);
        MapType expectedType = MapType.getInstance((AbstractType)AsciiType.instance, (AbstractType)DoubleType.instance, (boolean)true);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        mapType = DataType.map((DataType)DataType.ascii(), (DataType)DataType.cdouble(), (boolean)true);
        convertedType = CassandraTypeConverter.convert((DataType)mapType);
        expectedType = MapType.getInstance((AbstractType)AsciiType.instance, (AbstractType)DoubleType.instance, (boolean)false);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        Assert.assertTrue((String)"Expected convertType to be frozen", (boolean)convertedType.isFrozenCollection());
    }

    @Test
    public void testSet() {
        DataType.CollectionType setType = DataType.set((DataType)DataType.cfloat(), (boolean)false);
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)setType);
        SetType expectedType = SetType.getInstance((AbstractType)FloatType.instance, (boolean)true);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        setType = DataType.set((DataType)DataType.cfloat(), (boolean)true);
        convertedType = CassandraTypeConverter.convert((DataType)setType);
        expectedType = SetType.getInstance((AbstractType)FloatType.instance, (boolean)false);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        Assert.assertTrue((String)"Expected convertedType to be frozen", (boolean)convertedType.isFrozenCollection());
    }

    @Test
    public void testSmallInt() {
        DataType smallIntType = DataType.smallint();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)smallIntType);
        ShortType expectedType = ShortType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testText() {
        DataType textType = DataType.text();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)textType);
        UTF8Type expectedType = UTF8Type.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTime() {
        DataType timeType = DataType.time();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)timeType);
        TimeType expectedType = TimeType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTimestamp() {
        DataType timestampType = DataType.timestamp();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)timestampType);
        TimestampType expectedType = TimestampType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTimeUUID() {
        DataType timeUUID = DataType.timeuuid();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)timeUUID);
        TimeUUIDType expectedType = TimeUUIDType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTinyInt() {
        DataType tinyInt = DataType.tinyint();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)tinyInt);
        ByteType expectedType = ByteType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTuple() {
        TupleType tupleType = TupleType.of(null, null, (DataType[])new DataType[]{DataType.timestamp(), DataType.smallint()});
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)tupleType);
        ArrayList<Object> innerAbstractTypes = new ArrayList<Object>(2);
        innerAbstractTypes.add(TimestampType.instance);
        innerAbstractTypes.add(ShortType.instance);
        org.apache.cassandra.db.marshal.TupleType expectedType = new org.apache.cassandra.db.marshal.TupleType(innerAbstractTypes);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testUdt() {
        com.datastax.driver.core.UserType userType = (com.datastax.driver.core.UserType)Mockito.mock(com.datastax.driver.core.UserType.class);
        Mockito.when((Object)userType.getName()).thenReturn((Object)DataType.Name.UDT);
        Mockito.when((Object)userType.getTypeName()).thenReturn((Object)"FooType");
        Mockito.when((Object)userType.getKeyspace()).thenReturn((Object)"barspace");
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("asciiField");
        fieldNames.add("doubleField");
        Mockito.when((Object)userType.getFieldNames()).thenReturn(fieldNames);
        Mockito.when((Object)userType.getFieldType("asciiField")).thenReturn((Object)DataType.ascii());
        Mockito.when((Object)userType.getFieldType("doubleField")).thenReturn((Object)DataType.cdouble());
        Mockito.when((Object)userType.isFrozen()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        ByteBuffer expectedTypeName = ByteBuffer.wrap("FooType".getBytes(Charset.defaultCharset()));
        ArrayList<FieldIdentifier> expectedFieldIdentifiers = new ArrayList<FieldIdentifier>();
        expectedFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("asciiField".getBytes(Charset.defaultCharset()))));
        expectedFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("doubleField".getBytes(Charset.defaultCharset()))));
        ArrayList<Object> expectedFieldTypes = new ArrayList<Object>();
        expectedFieldTypes.add(AsciiType.instance);
        expectedFieldTypes.add(DoubleType.instance);
        UserType expectedAbstractType = new UserType("barspace", expectedTypeName, expectedFieldIdentifiers, expectedFieldTypes, true);
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)userType);
        Assert.assertEquals((Object)expectedAbstractType, (Object)convertedType);
        expectedAbstractType = new UserType("barspace", expectedTypeName, expectedFieldIdentifiers, expectedFieldTypes, false);
        convertedType = CassandraTypeConverter.convert((DataType)userType);
        Assert.assertEquals((Object)expectedAbstractType, (Object)convertedType);
    }

    @Test
    public void testUUID() {
        DataType uuid = DataType.uuid();
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)uuid);
        UUIDType expectedType = UUIDType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }
}

