/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.cassandra.CassandraSourceInfoStructMaker;
import io.debezium.connector.cassandra.CommitLogTransfer;
import io.debezium.connector.cassandra.Module;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorConfigException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.connect.storage.Converter;

public class CassandraConnectorConfig
extends CommonConnectorConfig {
    public static final String KAFKA_PRODUCER_CONFIG_PREFIX = "kafka.producer.";
    public static final String KEY_CONVERTER_PREFIX = "key.converter.";
    public static final String VALUE_CONVERTER_PREFIX = "value.converter.";
    public static final String COMMIT_LOG_TRANSFER_CONFIG_PREFIX = "commit.log.transfer.";
    public static final Field CONNECTOR_NAME = Field.create((String)"connector.name").withType(ConfigDef.Type.STRING);
    public static final Field KAFKA_TOPIC_PREFIX = Field.create((String)"kafka.topic.prefix").withType(ConfigDef.Type.STRING);
    public static final Field KEY_CONVERTER_CLASS_CONFIG = Field.create((String)"key.converter").withType(ConfigDef.Type.STRING);
    public static final Field VALUE_CONVERTER_CLASS_CONFIG = Field.create((String)"value.converter").withType(ConfigDef.Type.STRING);
    public static final String DEFAULT_SNAPSHOT_MODE = "INITIAL";
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withType(ConfigDef.Type.STRING).withDefault("INITIAL");
    public static final String DEFAULT_SNAPSHOT_CONSISTENCY = "QUORUM";
    public static final Field SNAPSHOT_CONSISTENCY = Field.create((String)"snapshot.consistency").withType(ConfigDef.Type.STRING).withDefault("QUORUM");
    public static final int DEFAULT_HTTP_PORT = 8000;
    public static final Field HTTP_PORT = Field.create((String)"http.port").withType(ConfigDef.Type.INT).withDefault(8000);
    public static final Field CASSANDRA_CONFIG = Field.create((String)"cassandra.config").withType(ConfigDef.Type.STRING);
    public static final String DEFAULT_CASSANDRA_HOST = "localhost";
    public static final Field CASSANDRA_HOSTS = Field.create((String)"cassandra.hosts").withType(ConfigDef.Type.STRING).withDefault("localhost");
    public static final int DEFAULT_CASSANDRA_PORT = 9042;
    public static final Field CASSANDRA_PORT = Field.create((String)"cassandra.port").withType(ConfigDef.Type.INT).withDefault(9042);
    public static final Field CASSANDRA_USERNAME = Field.create((String)"cassandra.username").withType(ConfigDef.Type.STRING);
    public static final Field CASSANDRA_PASSWORD = Field.create((String)"cassandra.password").withType(ConfigDef.Type.STRING);
    public static final boolean DEFAULT_CASSANDRA_SSL_ENABLED = false;
    public static final Field CASSANDRA_SSL_ENABLED = Field.create((String)"cassandra.ssl.enabled").withType(ConfigDef.Type.BOOLEAN).withDefault(false);
    public static final Field CASSANDRA_SSL_CONFIG_PATH = Field.create((String)"cassandra.ssl.config.path").withType(ConfigDef.Type.STRING);
    public static final Field COMMIT_LOG_RELOCATION_DIR = Field.create((String)"commit.log.relocation.dir").withType(ConfigDef.Type.STRING);
    public static final boolean DEFAULT_COMMIT_LOG_POST_PROCESSING_ENABLED = true;
    public static final Field COMMIT_LOG_POST_PROCESSING_ENABLED = Field.create((String)"commit.log.post.processing.enabled").withType(ConfigDef.Type.BOOLEAN).withDefault(true);
    public static final String DEFAULT_COMMIT_LOG_TRANSFER_CLASS = "io.debezium.connector.cassandra.BlackHoleCommitLogTransfer";
    public static final Field COMMIT_LOG_TRANSFER_CLASS = Field.create((String)"commit.log.transfer.class").withType(ConfigDef.Type.STRING).withDefault("io.debezium.connector.cassandra.BlackHoleCommitLogTransfer");
    public static final Field OFFSET_BACKING_STORE_DIR = Field.create((String)"offset.backing.store.dir").withType(ConfigDef.Type.STRING);
    public static final int DEFAULT_OFFSET_FLUSH_INTERVAL_MS = 0;
    public static final Field OFFSET_FLUSH_INTERVAL_MS = Field.create((String)"offset.flush.interval.ms").withType(ConfigDef.Type.INT).withDefault(0);
    public static final int DEFAULT_MAX_OFFSET_FLUSH_SIZE = 100;
    public static final Field MAX_OFFSET_FLUSH_SIZE = Field.create((String)"max.offset.flush.size").withType(ConfigDef.Type.INT).withDefault(100);
    public static final int DEFAULT_SCHEMA_POLL_INTERVAL_MS = 10000;
    public static final Field SCHEMA_POLL_INTERVAL_MS = Field.create((String)"schema.refresh.interval.ms").withType(ConfigDef.Type.INT).withDefault(10000);
    public static final int DEFAULT_CDC_DIR_POLL_INTERVAL_MS = 10000;
    public static final Field CDC_DIR_POLL_INTERVAL_MS = Field.create((String)"cdc.dir.poll.interval.ms").withType(ConfigDef.Type.INT).withDefault(10000);
    public static final int DEFAULT_SNAPSHOT_POLL_INTERVAL_MS = 10000;
    public static final Field SNAPSHOT_POLL_INTERVAL_MS = Field.create((String)"snapshot.scan.interval.ms").withType(ConfigDef.Type.INT).withDefault(10000);
    public static final Field FIELD_BLACKLIST = Field.create((String)"field.blacklist").withType(ConfigDef.Type.STRING);
    public static final boolean DEFAULT_LATEST_COMMIT_LOG_ONLY = false;
    public static final Field LATEST_COMMIT_LOG_ONLY = Field.create((String)"latest.commit.log.only").withType(ConfigDef.Type.BOOLEAN).withDefault(false);
    public static final int DEFAULT_POLL_INTERVAL_MS = 1000;
    public static final boolean DEFAULT_TOMBSTONES_ON_DELETE = false;
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 0;

    public CassandraConnectorConfig(Configuration config) {
        super(config, config.getString(CONNECTOR_NAME), 0);
    }

    public String connectorName() {
        return this.getConfig().getString(CONNECTOR_NAME);
    }

    public String kafkaTopicPrefix() {
        return this.getConfig().getString(KAFKA_TOPIC_PREFIX);
    }

    public Properties getKafkaConfigs() {
        Properties props = new Properties();
        props.put("key.serializer", ByteArraySerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        this.getConfig().asMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(KAFKA_PRODUCER_CONFIG_PREFIX)).forEach(entry -> {
            String k = ((String)entry.getKey()).replace(KAFKA_PRODUCER_CONFIG_PREFIX, "");
            Object v = entry.getValue();
            props.put(k, v);
        });
        return props;
    }

    public Properties commitLogTransferConfigs() {
        Properties props = new Properties();
        this.getConfig().asMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(COMMIT_LOG_TRANSFER_CONFIG_PREFIX)).forEach(entry -> props.put(entry.getKey(), entry.getValue()));
        return props;
    }

    public boolean latestCommitLogOnly() {
        return this.getConfig().getBoolean(LATEST_COMMIT_LOG_ONLY);
    }

    public SnapshotMode snapshotMode() {
        String mode = this.getConfig().getString(SNAPSHOT_MODE);
        Optional<SnapshotMode> snapshotModeOpt = SnapshotMode.fromText(mode);
        return snapshotModeOpt.orElseThrow(() -> new CassandraConnectorConfigException(mode + " is not a valid SnapshotMode"));
    }

    public ConsistencyLevel snapshotConsistencyLevel() {
        String cl = this.getConfig().getString(SNAPSHOT_CONSISTENCY);
        return ConsistencyLevel.valueOf((String)cl);
    }

    public int httpPort() {
        return this.getConfig().getInteger(HTTP_PORT);
    }

    public String cassandraConfig() {
        return this.getConfig().getString(CASSANDRA_CONFIG);
    }

    public String[] cassandraHosts() {
        String hosts = this.getConfig().getString(CASSANDRA_HOSTS);
        return hosts.split(",");
    }

    public int cassandraPort() {
        return this.getConfig().getInteger(CASSANDRA_PORT);
    }

    public boolean cassandraSslEnabled() {
        return this.getConfig().getBoolean(CASSANDRA_SSL_ENABLED);
    }

    public String cassandraSslConfigPath() {
        return this.getConfig().getString(CASSANDRA_SSL_CONFIG_PATH);
    }

    public String cassandraUsername() {
        return this.getConfig().getString(CASSANDRA_USERNAME);
    }

    public String cassandraPassword() {
        return this.getConfig().getString(CASSANDRA_PASSWORD);
    }

    public String commitLogRelocationDir() {
        return this.getConfig().getString(COMMIT_LOG_RELOCATION_DIR);
    }

    public boolean postProcessEnabled() {
        return this.getConfig().getBoolean(COMMIT_LOG_POST_PROCESSING_ENABLED);
    }

    public CommitLogTransfer getCommitLogTransfer() {
        try {
            String clazz = this.getConfig().getString(COMMIT_LOG_TRANSFER_CLASS);
            CommitLogTransfer transfer = (CommitLogTransfer)Class.forName(clazz).newInstance();
            transfer.init(this.commitLogTransferConfigs());
            return transfer;
        }
        catch (Exception e) {
            throw new CassandraConnectorConfigException(e);
        }
    }

    public String offsetBackingStoreDir() {
        return this.getConfig().getString(OFFSET_BACKING_STORE_DIR);
    }

    public Duration offsetFlushIntervalMs() {
        int ms = this.getConfig().getInteger(OFFSET_FLUSH_INTERVAL_MS);
        return Duration.ofMillis(ms);
    }

    public long maxOffsetFlushSize() {
        return this.getConfig().getLong(MAX_OFFSET_FLUSH_SIZE);
    }

    public int maxQueueSize() {
        return this.getConfig().getInteger(MAX_QUEUE_SIZE);
    }

    public int maxBatchSize() {
        return this.getConfig().getInteger(MAX_BATCH_SIZE);
    }

    public Duration pollIntervalMs() {
        int ms = this.getConfig().getInteger(POLL_INTERVAL_MS, 1000);
        return Duration.ofMillis(ms);
    }

    public Duration schemaPollIntervalMs() {
        int ms = this.getConfig().getInteger(SCHEMA_POLL_INTERVAL_MS);
        return Duration.ofMillis(ms);
    }

    public Duration cdcDirPollIntervalMs() {
        int ms = this.getConfig().getInteger(CDC_DIR_POLL_INTERVAL_MS);
        return Duration.ofMillis(ms);
    }

    public Duration snapshotPollIntervalMs() {
        int ms = this.getConfig().getInteger(SNAPSHOT_POLL_INTERVAL_MS);
        return Duration.ofMillis(ms);
    }

    public String[] fieldBlacklist() {
        String hosts = this.getConfig().getString(FIELD_BLACKLIST);
        if (hosts == null) {
            return new String[0];
        }
        return hosts.split(",");
    }

    public boolean tombstonesOnDelete() {
        return this.getConfig().getBoolean(TOMBSTONES_ON_DELETE, false);
    }

    public Converter getKeyConverter() throws CassandraConnectorConfigException {
        try {
            Class<?> keyConverterClass = Class.forName(this.getConfig().getString(KEY_CONVERTER_CLASS_CONFIG));
            Converter keyConverter = (Converter)keyConverterClass.newInstance();
            Map<String, Object> keyConverterConfigs = this.keyValueConverterConfigs(KEY_CONVERTER_PREFIX);
            keyConverter.configure(keyConverterConfigs, true);
            return keyConverter;
        }
        catch (Exception e) {
            throw new CassandraConnectorConfigException(e);
        }
    }

    public Converter getValueConverter() throws CassandraConnectorConfigException {
        try {
            Class<?> valueConverterClass = Class.forName(this.getConfig().getString(VALUE_CONVERTER_CLASS_CONFIG));
            Converter valueConverter = (Converter)valueConverterClass.newInstance();
            Map<String, Object> valueConverterConfigs = this.keyValueConverterConfigs(VALUE_CONVERTER_PREFIX);
            valueConverter.configure(valueConverterConfigs, false);
            return valueConverter;
        }
        catch (Exception e) {
            throw new CassandraConnectorConfigException(e);
        }
    }

    private Map<String, Object> keyValueConverterConfigs(String converterPrefix) {
        return this.getConfig().asMap().entrySet().stream().filter(entry -> entry.toString().startsWith(converterPrefix)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).replace(converterPrefix, ""), entry -> (String)entry.getValue()));
    }

    public String toString() {
        return this.getConfig().asMap().entrySet().stream().filter(e -> !((String)e.getKey()).toLowerCase().contains("username") && !((String)e.getKey()).toLowerCase().contains("password")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).toString();
    }

    public String getContextName() {
        return Module.contextName();
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new CassandraSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    public String getConnectorName() {
        return Module.name();
    }

    public static enum SnapshotMode {
        ALWAYS,
        INITIAL,
        NEVER;


        public static Optional<SnapshotMode> fromText(String text) {
            return Arrays.stream(SnapshotMode.values()).filter(v -> text != null && v.name().toLowerCase().equals(text.toLowerCase())).findFirst();
        }
    }
}

