/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.transport.ProtocolVersion;

public class SinglePartitionPager
extends AbstractQueryPager {
    private final SinglePartitionReadCommand command;
    private volatile PagingState.RowMark lastReturned;

    public SinglePartitionPager(SinglePartitionReadCommand command, PagingState state, ProtocolVersion protocolVersion) {
        super(command, protocolVersion);
        this.command = command;
        if (state != null) {
            this.lastReturned = state.rowMark;
            this.restoreState(command.partitionKey(), state.remaining, state.remainingInPartition);
        }
    }

    private SinglePartitionPager(SinglePartitionReadCommand command, ProtocolVersion protocolVersion, PagingState.RowMark rowMark, int remaining, int remainingInPartition) {
        super(command, protocolVersion);
        this.command = command;
        this.lastReturned = rowMark;
        this.restoreState(command.partitionKey(), remaining, remainingInPartition);
    }

    @Override
    public SinglePartitionPager withUpdatedLimit(DataLimits newLimits) {
        return new SinglePartitionPager(this.command.withUpdatedLimit(newLimits), this.protocolVersion, this.lastReturned, this.maxRemaining(), this.remainingInPartition());
    }

    public ByteBuffer key() {
        return this.command.partitionKey().getKey();
    }

    public DataLimits limits() {
        return this.command.limits();
    }

    @Override
    public PagingState state() {
        return this.lastReturned == null ? null : new PagingState(null, this.lastReturned, this.maxRemaining(), this.remainingInPartition());
    }

    @Override
    protected ReadCommand nextPageReadCommand(int pageSize) {
        Clustering clustering = this.lastReturned == null ? null : this.lastReturned.clustering(this.command.metadata());
        DataLimits limits = this.lastReturned == null || this.command.isForThrift() ? this.limits().forPaging(pageSize) : this.limits().forPaging(pageSize, this.key(), this.remainingInPartition());
        return this.command.forPaging(clustering, limits);
    }

    @Override
    protected void recordLast(DecoratedKey key, Row last) {
        if (last != null && last.clustering() != Clustering.STATIC_CLUSTERING) {
            this.lastReturned = PagingState.RowMark.create(this.command.metadata(), last, this.protocolVersion);
        }
    }

    @Override
    protected boolean isPreviouslyReturnedPartition(DecoratedKey key) {
        return this.lastReturned != null;
    }
}

