/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaAvroSerializer
extends AbstractKafkaAvroSerializer
implements Serializer<Object> {
    private boolean isKey;

    public KafkaAvroSerializer() {
    }

    public KafkaAvroSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public KafkaAvroSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this.schemaRegistry = client;
        this.configure(this.serializerConfig(props));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaAvroSerializerConfig(configs));
    }

    public byte[] serialize(String topic, Object record) {
        if (record == null) {
            return null;
        }
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, record, (ParsedSchema)new AvroSchema(AvroSchemaUtils.getSchema((Object)record, (boolean)this.useSchemaReflection))), record);
    }

    public void close() {
    }
}

