/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.OffsetPosition;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorConfigException;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOffsetWriter
implements OffsetWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileOffsetWriter.class);
    public static final String SNAPSHOT_OFFSET_FILE = "snapshot_offset.properties";
    public static final String COMMITLOG_OFFSET_FILE = "commitlog_offset.properties";
    private final Properties snapshotProps = new Properties();
    private final Properties commitLogProps = new Properties();
    private final File offsetDir;
    private final File snapshotOffsetFile;
    private final File commitLogOffsetFile;
    private final FileLock snapshotOffsetFileLock;
    private final FileLock commitLogOffsetFileLock;

    public FileOffsetWriter(String offsetDir) throws IOException {
        if (offsetDir == null) {
            throw new CassandraConnectorConfigException("Offset file directory must be configured at the start");
        }
        this.offsetDir = new File(offsetDir);
        this.snapshotOffsetFile = Paths.get(this.offsetDir.getAbsolutePath(), SNAPSHOT_OFFSET_FILE).toFile();
        this.commitLogOffsetFile = Paths.get(this.offsetDir.getAbsolutePath(), COMMITLOG_OFFSET_FILE).toFile();
        this.snapshotOffsetFileLock = this.init(this.snapshotOffsetFile);
        this.commitLogOffsetFileLock = this.init(this.commitLogOffsetFile);
        this.loadOffset(this.snapshotOffsetFile, this.snapshotProps);
        this.loadOffset(this.commitLogOffsetFile, this.commitLogProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markOffset(String sourceTable, String sourceOffset, boolean isSnapshot) {
        if (isSnapshot) {
            FileLock fileLock = this.snapshotOffsetFileLock;
            synchronized (fileLock) {
                if (!this.isOffsetProcessed(sourceTable, sourceOffset, isSnapshot)) {
                    this.snapshotProps.setProperty(sourceTable, sourceOffset);
                }
            }
        }
        FileLock fileLock = this.commitLogOffsetFileLock;
        synchronized (fileLock) {
            if (!this.isOffsetProcessed(sourceTable, sourceOffset, isSnapshot)) {
                this.commitLogProps.setProperty(sourceTable, sourceOffset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOffsetProcessed(String sourceTable, String sourceOffset, boolean isSnapshot) {
        if (isSnapshot) {
            FileLock fileLock = this.snapshotOffsetFileLock;
            synchronized (fileLock) {
                return this.snapshotProps.containsKey(sourceTable);
            }
        }
        FileLock fileLock = this.commitLogOffsetFileLock;
        synchronized (fileLock) {
            OffsetPosition currentOffset = OffsetPosition.parse(sourceOffset);
            OffsetPosition recordedOffset = this.commitLogProps.containsKey(sourceTable) ? OffsetPosition.parse((String)this.commitLogProps.get(sourceTable)) : null;
            return recordedOffset != null && currentOffset.compareTo(recordedOffset) <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            FileLock fileLock = this.snapshotOffsetFileLock;
            synchronized (fileLock) {
                FileOffsetWriter.saveOffset(this.snapshotOffsetFile, this.snapshotProps);
            }
            fileLock = this.commitLogOffsetFileLock;
            synchronized (fileLock) {
                FileOffsetWriter.saveOffset(this.commitLogOffsetFile, this.commitLogProps);
            }
        }
        catch (IOException e) {
            LOGGER.error("Ignoring flush failure", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.snapshotOffsetFileLock.release();
        }
        catch (IOException e) {
            LOGGER.error("Failed to release snapshot offset file lock");
        }
        try {
            this.commitLogOffsetFileLock.release();
        }
        catch (IOException e) {
            LOGGER.error("Failed to release commit log offset file lock");
        }
    }

    private static void saveOffset(File offsetFile, Properties props) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(offsetFile);){
            props.store(fos, null);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save offset for file " + offsetFile.getName(), (Throwable)e);
            throw e;
        }
    }

    private void loadOffset(File offsetFile, Properties props) throws IOException {
        try (FileInputStream fis = new FileInputStream(offsetFile);){
            props.load(fis);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load offset for file " + offsetFile.getName(), (Throwable)e);
            throw e;
        }
    }

    private FileLock init(File offsetFile) throws IOException {
        if (!offsetFile.exists()) {
            try {
                Files.createDirectories(this.offsetDir.toPath(), new FileAttribute[0]);
                Files.createFile(offsetFile.toPath(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        try {
            FileChannel channel = FileChannel.open(offsetFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
            FileLock lock = channel.tryLock();
            if (lock == null) {
                throw new CassandraConnectorTaskException("Failed to acquire file lock on " + offsetFile.getName() + ". There might be another Cassandra Connector Task running");
            }
            return lock;
        }
        catch (OverlappingFileLockException e) {
            throw new CassandraConnectorTaskException("Failed to acquire file lock on " + offsetFile.getName() + ". There might be another thread running", e);
        }
    }
}

