/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Key;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;

public abstract class RelationalDatabaseConnectorConfig
extends CommonConnectorConfig {
    private static final String TABLE_BLACKLIST_NAME = "table.blacklist";
    private static final String TABLE_WHITELIST_NAME = "table.whitelist";
    private static final Pattern MSG_KEY_COLUMNS_PATTERN = Pattern.compile("^(([^:]+):([^:;\\s]+))+[^;]$");
    public static final long DEFAULT_SNAPSHOT_LOCK_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    public static final Field SERVER_NAME = Field.create("database.server.name").withDisplayName("Namespace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("Unique name that identifies the database server and all recorded offsets, and that is used as a prefix for all schemas and topics. Each distinct installation should have a separate namespace and be monitored by at most one Debezium connector.");
    public static final Field TABLE_WHITELIST = Field.create("table.whitelist").withDisplayName("Included tables").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isListOfRegex).withDescription("The tables for which changes are to be captured");
    public static final Field TABLE_BLACKLIST = Field.create("table.blacklist").withDisplayName("Excluded tables").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(Field::isListOfRegex, RelationalDatabaseConnectorConfig::validateTableBlacklist).withInvisibleRecommender();
    public static final Field TABLE_IGNORE_BUILTIN = Field.create("table.ignore.builtin").withDisplayName("Ignore system databases").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withValidation(Field::isBoolean).withDescription("Flag specifying whether built-in tables should be ignored.");
    public static final Field COLUMN_BLACKLIST = Field.create("column.blacklist").withDisplayName("Exclude Columns").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(RelationalDatabaseConnectorConfig::validateColumnBlacklist).withDescription("Regular expressions matching columns to exclude from change events");
    public static final Field COLUMN_WHITELIST = Field.create("column.whitelist").withDisplayName("Include Columns").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Regular expressions matching columns to include in change events");
    public static final Field MSG_KEY_COLUMNS = Field.create("message.key.columns").withDisplayName("Columns PK mapping").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(RelationalDatabaseConnectorConfig::validateMessageKeyColumnsField).withDescription("A semicolon-separated list of expressions that match fully-qualified tables and column(s) to be used as message key. Each expression must match the pattern '<fully-qualified table name>:<key columns>',where the table names could be defined as (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the specific connector,and the key columns are a comma-separated list of columns representing the custom key. For any table without an explicit key configuration the table's primary key column(s) will be used as message key.Example: dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id");
    public static final Field DECIMAL_HANDLING_MODE = Field.create("decimal.handling.mode").withDisplayName("Decimal Handling").withEnum(DecimalHandlingMode.class, DecimalHandlingMode.PRECISE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how DECIMAL and NUMERIC columns should be represented in change events, including:'precise' (the default) uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to represent values; 'double' represents values using Java's 'double', which may not offer the precision but will be far easier to use in consumers.");
    public static final Field SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE = Field.create("snapshot.select.statement.overrides").withDisplayName("List of tables where the default select statement used during snapshotting should be overridden.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription(" This property contains a comma-separated list of fully-qualified tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on thespecific connectors . Select statements for the individual tables are specified in further configuration properties, one for each table, identified by the id 'snapshot.select.statement.overrides.[DB_NAME].[TABLE_NAME]' or 'snapshot.select.statement.overrides.[SCHEMA_NAME].[TABLE_NAME]', respectively. The value of those properties is the select statement to use when retrieving data from the specific table during snapshotting. A possible use case for large append-only tables is setting a specific point where to start (resume) snapshotting, in case a previous snapshotting was interrupted.");
    public static final Field SCHEMA_WHITELIST = Field.create("schema.whitelist").withDisplayName("Schemas").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDependents("table.whitelist").withDescription("The schemas for which events should be captured");
    public static final Field SCHEMA_BLACKLIST = Field.create("schema.blacklist").withDisplayName("Exclude Schemas").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(RelationalDatabaseConnectorConfig::validateSchemaBlacklist).withInvisibleRecommender().withDescription("The schemas for which events must not be captured");
    public static final Field TIME_PRECISION_MODE = Field.create("time.precision.mode").withDisplayName("Time Precision").withEnum(TemporalPrecisionMode.class, TemporalPrecisionMode.ADAPTIVE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Time, date, and timestamps can be represented with different kinds of precisions, including:'adaptive' (the default) bases the precision of time, date, and timestamp values on the database column's precision; 'adaptive_time_microseconds' like 'adaptive' mode, but TIME fields always use microseconds precision;'connect' always represents time, date, and timestamp values using Kafka Connect's built-in representations for Time, Date, and Timestamp, which uses millisecond precision regardless of the database columns' precision .");
    public static final Field SNAPSHOT_LOCK_TIMEOUT_MS = Field.create("snapshot.lock.timeout.ms").withDisplayName("Snapshot lock timeout (ms)").withWidth(ConfigDef.Width.LONG).withType(ConfigDef.Type.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDefault(DEFAULT_SNAPSHOT_LOCK_TIMEOUT_MILLIS).withDescription("The maximum number of millis to wait for table locks at the beginning of a snapshot. If locks cannot be acquired in this time frame, the snapshot will be aborted. Defaults to 10 seconds");
    public static final Field INCLUDE_SCHEMA_CHANGES = Field.create("include.schema.changes").withDisplayName("Include database schema changes").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether the connector should publish changes in the database schema to a Kafka topic with the same name as the database server ID. Each schema change will be recorded using a key that contains the database name and whose value include logical description of the new schema and optionally the DDL statement(s).The default is 'true'. This is independent of how the connector internally records database history.").withDefault(true);
    public static final Field MASK_COLUMN_WITH_HASH = Field.create("column.mask.hash.([^.]+).with.salt.(.+)").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("A comma-separated list of regular expressions matching fully-qualified names of columns that should be masked by hashing the input. Using the specified hash algorithms and salt.");
    public static final Field MASK_COLUMN = Field.create("column.mask.with.(d+).chars").withValidation(Field::isInteger).withDescription("A comma-separated list of regular expressions matching fully-qualified names of columns that should be masked with configured amount of asterisk ('*') characters.");
    public static final Field TRUNCATE_COLUMN = Field.create("column.truncate.to.(d+).chars").withValidation(Field::isInteger).withDescription("A comma-separated list of regular expressions matching fully-qualified names of columns that should be truncated to the configured amount of characters.");
    protected static final ConfigDefinition CONFIG_DEFINITION = CommonConnectorConfig.CONFIG_DEFINITION.edit().type(SERVER_NAME).connector(DECIMAL_HANDLING_MODE, TIME_PRECISION_MODE, SNAPSHOT_LOCK_TIMEOUT_MS).events(COLUMN_WHITELIST, COLUMN_BLACKLIST, TABLE_WHITELIST, TABLE_BLACKLIST, TABLE_IGNORE_BUILTIN, SCHEMA_WHITELIST, SCHEMA_BLACKLIST, MSG_KEY_COLUMNS, SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, MASK_COLUMN_WITH_HASH, MASK_COLUMN, TRUNCATE_COLUMN, INCLUDE_SCHEMA_CHANGES).create();
    private final RelationalTableFilters tableFilters;
    private final TemporalPrecisionMode temporalPrecisionMode;
    private final Key.KeyMapper keyMapper;

    protected RelationalDatabaseConnectorConfig(Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper, int defaultSnapshotFetchSize) {
        super(config, logicalName, defaultSnapshotFetchSize);
        this.temporalPrecisionMode = TemporalPrecisionMode.parse(config.getString(TIME_PRECISION_MODE));
        this.keyMapper = Key.CustomKeyMapper.getInstance(config.getString(MSG_KEY_COLUMNS));
        this.tableFilters = systemTablesFilter != null && tableIdMapper != null ? new RelationalTableFilters(config, systemTablesFilter, tableIdMapper) : null;
    }

    public RelationalTableFilters getTableFilters() {
        return this.tableFilters;
    }

    public JdbcValueConverters.DecimalMode getDecimalMode() {
        return DecimalHandlingMode.parse(this.getConfig().getString(DECIMAL_HANDLING_MODE)).asDecimalMode();
    }

    public TemporalPrecisionMode getTemporalPrecisionMode() {
        return this.temporalPrecisionMode;
    }

    public Key.KeyMapper getKeyMapper() {
        return this.keyMapper;
    }

    public Duration snapshotLockTimeout() {
        return Duration.ofMillis(this.getConfig().getLong(SNAPSHOT_LOCK_TIMEOUT_MS));
    }

    private static int validateColumnBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(COLUMN_WHITELIST);
        String blacklist = config.getString(COLUMN_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(COLUMN_BLACKLIST, blacklist, "Column whitelist is already specified");
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSchemaChangesHistoryEnabled() {
        return this.getConfig().getBoolean(INCLUDE_SCHEMA_CHANGES);
    }

    private static int validateTableBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(TABLE_WHITELIST);
        String blacklist = config.getString(TABLE_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(TABLE_BLACKLIST, blacklist, "Table whitelist is already specified");
            return 1;
        }
        return 0;
    }

    public Map<TableId, String> getSnapshotSelectOverridesByTable() {
        String tableList = this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE);
        if (tableList == null) {
            return Collections.emptyMap();
        }
        HashMap<TableId, String> snapshotSelectOverridesByTable = new HashMap<TableId, String>();
        for (String table : tableList.split(",")) {
            snapshotSelectOverridesByTable.put(TableId.parse(table), this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + table));
        }
        return Collections.unmodifiableMap(snapshotSelectOverridesByTable);
    }

    private static int validateSchemaBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(SCHEMA_WHITELIST);
        String blacklist = config.getString(SCHEMA_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(SCHEMA_BLACKLIST, blacklist, "Schema whitelist is already specified");
            return 1;
        }
        return 0;
    }

    private static int validateMessageKeyColumnsField(Configuration config, Field field, Field.ValidationOutput problems) {
        String msgKeyColumns = config.getString(MSG_KEY_COLUMNS);
        if (msgKeyColumns != null && !MSG_KEY_COLUMNS_PATTERN.asPredicate().test(msgKeyColumns)) {
            problems.accept(MSG_KEY_COLUMNS, msgKeyColumns, MSG_KEY_COLUMNS.name() + " has an invalid format (expecting '" + MSG_KEY_COLUMNS_PATTERN.pattern() + "')");
            return 1;
        }
        return 0;
    }

    public static enum DecimalHandlingMode implements EnumeratedValue
    {
        PRECISE("precise"),
        STRING("string"),
        DOUBLE("double");

        private final String value;

        private DecimalHandlingMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public JdbcValueConverters.DecimalMode asDecimalMode() {
            switch (this) {
                case DOUBLE: {
                    return JdbcValueConverters.DecimalMode.DOUBLE;
                }
                case STRING: {
                    return JdbcValueConverters.DecimalMode.STRING;
                }
            }
            return JdbcValueConverters.DecimalMode.PRECISE;
        }

        public static DecimalHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (DecimalHandlingMode option : DecimalHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static DecimalHandlingMode parse(String value, String defaultValue) {
            DecimalHandlingMode mode = DecimalHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = DecimalHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

