/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.util.NoSuchElementException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;

public class SingletonUnfilteredPartitionIterator
implements UnfilteredPartitionIterator {
    private final UnfilteredRowIterator iter;
    private final boolean isForThrift;
    private boolean returned;

    public SingletonUnfilteredPartitionIterator(UnfilteredRowIterator iter, boolean isForThrift) {
        this.iter = iter;
        this.isForThrift = isForThrift;
    }

    @Override
    public boolean isForThrift() {
        return this.isForThrift;
    }

    @Override
    public CFMetaData metadata() {
        return this.iter.metadata();
    }

    @Override
    public boolean hasNext() {
        return !this.returned;
    }

    @Override
    public UnfilteredRowIterator next() {
        if (this.returned) {
            throw new NoSuchElementException();
        }
        this.returned = true;
        return this.iter;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (!this.returned) {
            this.iter.close();
        }
    }
}

