/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.jackson.AbstractModelConverter;
import io.swagger.jackson.JAXBAnnotationsHelper;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Xml;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.AllowableValues;
import io.swagger.util.AllowableValuesUtils;
import io.swagger.util.PrimitiveType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelResolver
extends AbstractModelConverter
implements ModelConverter {
    Logger LOGGER = LoggerFactory.getLogger(ModelResolver.class);

    public ModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    public ObjectMapper objectMapper() {
        return this._mapper;
    }

    protected boolean shouldIgnoreClass(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.getName().equals("javax.ws.rs.Response")) {
                return true;
            }
        } else if (type instanceof ResolvedType) {
            ResolvedType rt = (ResolvedType)type;
            this.LOGGER.debug("Can't check class " + type + ", " + rt.getRawClass().getName());
            if (rt.getRawClass().equals(Class.class)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolveProperty(this._mapper.constructType(type), context, annotations, next);
    }

    public Property resolveProperty(JavaType propType, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> next) {
        this.LOGGER.debug("resolveProperty " + propType);
        Property property = null;
        if (propType.isContainerType()) {
            JavaType keyType = propType.getKeyType();
            JavaType valueType = propType.getContentType();
            if (keyType != null && valueType != null) {
                property = new MapProperty().additionalProperties(context.resolveProperty((Type)valueType, new Annotation[0]));
            } else if (valueType != null) {
                ArrayProperty arrayProperty = new ArrayProperty().items(context.resolveProperty((Type)valueType, new Annotation[0]));
                if (this._isSetType(propType.getRawClass())) {
                    arrayProperty.setUniqueItems(Boolean.valueOf(true));
                }
                property = arrayProperty;
            }
        } else {
            property = PrimitiveType.createProperty((Type)propType);
        }
        if (property == null) {
            if (propType.isEnumType()) {
                property = new StringProperty();
                this._addEnumProps(propType.getRawClass(), property);
            } else if (this._isOptionalType(propType)) {
                property = context.resolveProperty((Type)propType.containedType(0), null);
            } else {
                Model innerModel = context.resolve((Type)propType);
                if (innerModel instanceof ModelImpl) {
                    ModelImpl mi = (ModelImpl)innerModel;
                    property = new RefProperty(StringUtils.isNotEmpty((CharSequence)mi.getReference()) ? mi.getReference() : mi.getName());
                }
            }
        }
        return property;
    }

    private boolean _isOptionalType(JavaType propType) {
        return "com.google.common.base.Optional".equals(propType.getRawClass().getCanonicalName());
    }

    @Override
    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> next) {
        if (this.shouldIgnoreClass(type)) {
            return null;
        }
        return this.resolve(this._mapper.constructType(type), context, next);
    }

    protected void _addEnumProps(Class<?> propClass, Property property) {
        boolean useIndex = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        boolean useToString = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        Class<?> enumClass = propClass;
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            String n = useIndex ? String.valueOf(en.ordinal()) : (useToString ? en.toString() : this._intr.findEnumValue(en));
            if (!(property instanceof StringProperty)) continue;
            StringProperty sp = (StringProperty)property;
            sp._enum(n);
        }
    }

    public Model resolve(JavaType type, ModelConverterContext context, Iterator<ModelConverter> next) {
        JsonTypeInfo typeInfo;
        ApiModel apiModel;
        String disc;
        if (type.isEnumType() || PrimitiveType.fromType((Type)type) != null) {
            return null;
        }
        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
        String name = this._typeName(type, beanDesc);
        if ("Object".equals(name)) {
            return new ModelImpl();
        }
        ModelImpl model = new ModelImpl().type("object").name(name).description(this._description((Annotated)beanDesc.getClassInfo()));
        if (!type.isContainerType()) {
            context.defineModel(name, (Model)model, (Type)type, null);
        }
        if (type.isContainerType()) {
            context.resolve((Type)type.getContentType());
            return null;
        }
        XmlRootElement rootAnnotation = (XmlRootElement)beanDesc.getClassAnnotations().get(XmlRootElement.class);
        if (rootAnnotation != null && !"".equals(rootAnnotation.name()) && !"##default".equals(rootAnnotation.name())) {
            this.LOGGER.debug(rootAnnotation.toString());
            Xml xml = new Xml().name(rootAnnotation.name());
            if (rootAnnotation.namespace() != null && !"".equals(rootAnnotation.namespace()) && !"##default".equals(rootAnnotation.namespace())) {
                xml.namespace(rootAnnotation.namespace());
            }
            model.xml(xml);
        }
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        JsonIgnoreProperties ignoreProperties = (JsonIgnoreProperties)beanDesc.getClassAnnotations().get(JsonIgnoreProperties.class);
        if (ignoreProperties != null) {
            propertiesToIgnore.addAll(Arrays.asList(ignoreProperties.value()));
        }
        String string = disc = (apiModel = (ApiModel)beanDesc.getClassAnnotations().get(ApiModel.class)) == null ? "" : apiModel.discriminator();
        if (apiModel != null && StringUtils.isNotEmpty((CharSequence)apiModel.reference())) {
            model.setReference(apiModel.reference());
        }
        if (disc.isEmpty() && (typeInfo = (JsonTypeInfo)beanDesc.getClassAnnotations().get(JsonTypeInfo.class)) != null) {
            disc = typeInfo.property();
        }
        if (!disc.isEmpty()) {
            model.setDiscriminator(disc);
        }
        ArrayList<Property> props = new ArrayList<Property>();
        for (BeanPropertyDefinition propDef : beanDesc.findProperties()) {
            AllowableValues allowableValues;
            Integer index;
            String description;
            Boolean required;
            JsonProperty pd;
            String altName;
            Member member;
            Object property = null;
            String propName = propDef.getName();
            Annotation[] annotations = null;
            if (propDef.getPrimaryMember() != null && (member = propDef.getPrimaryMember().getMember()) != null && (altName = member.getName()) != null) {
                int length = altName.length();
                for (String prefix : Arrays.asList("get", "is")) {
                    int offset = prefix.length();
                    if (!altName.startsWith(prefix) || length <= offset || Character.isUpperCase(altName.charAt(offset))) continue;
                    propName = altName;
                    break;
                }
            }
            PropertyMetadata md = propDef.getMetadata();
            boolean hasSetter = false;
            boolean hasGetter = false;
            hasSetter = propDef.getSetter() != null;
            if (propDef.getGetter() != null && (pd = (JsonProperty)propDef.getGetter().getAnnotation(JsonProperty.class)) != null) {
                hasGetter = true;
            }
            Boolean isReadOnly = null;
            isReadOnly = !hasSetter & hasGetter ? Boolean.TRUE : Boolean.FALSE;
            AnnotatedMember member2 = propDef.getPrimaryMember();
            if (member2 == null || propertiesToIgnore.contains(propName)) continue;
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (Annotation a : member2.annotations()) {
                annotationList.add(a);
            }
            annotations = annotationList.toArray(new Annotation[annotationList.size()]);
            ApiModelProperty mp = (ApiModelProperty)member2.getAnnotation(ApiModelProperty.class);
            if (mp != null && mp.readOnly()) {
                isReadOnly = mp.readOnly();
            }
            JavaType propType = member2.getType(beanDesc.bindingsForBeanType());
            if (mp != null && !mp.name().isEmpty()) {
                propName = mp.name();
            }
            if (mp != null && !mp.dataType().isEmpty()) {
                String or = mp.dataType();
                JavaType innerJavaType = null;
                this.LOGGER.debug("overriding datatype from " + propType + " to " + or);
                if (or.toLowerCase().startsWith("list[")) {
                    String innerType = or.substring(5, or.length() - 1);
                    ArrayProperty p = new ArrayProperty();
                    Property primitiveProperty = PrimitiveType.createProperty(innerType);
                    if (primitiveProperty != null) {
                        p.setItems(primitiveProperty);
                    } else {
                        innerJavaType = this.getInnerType(innerType);
                        p.setItems(context.resolveProperty((Type)innerJavaType, annotations));
                    }
                    property = p;
                } else if (or.toLowerCase().startsWith("map[")) {
                    int pos = or.indexOf(",");
                    if (pos > 0) {
                        String innerType = or.substring(pos + 1, or.length() - 1);
                        MapProperty p = new MapProperty();
                        Property primitiveProperty = PrimitiveType.createProperty(innerType);
                        if (primitiveProperty != null) {
                            p.setAdditionalProperties(primitiveProperty);
                        } else {
                            innerJavaType = this.getInnerType(innerType);
                            p.setAdditionalProperties(context.resolveProperty((Type)innerJavaType, annotations));
                        }
                        property = p;
                    }
                } else {
                    Property primitiveProperty = PrimitiveType.createProperty(or);
                    if (primitiveProperty != null) {
                        property = primitiveProperty;
                    } else {
                        innerJavaType = this.getInnerType(or);
                        property = context.resolveProperty((Type)innerJavaType, annotations);
                    }
                }
                if (innerJavaType != null) {
                    context.resolve((Type)innerJavaType);
                }
            }
            if (property == null) {
                property = mp != null && StringUtils.isNotEmpty((CharSequence)mp.reference()) ? new RefProperty(mp.reference()) : context.resolveProperty((Type)propType, annotations);
            }
            if (property == null) continue;
            property.setName(propName);
            if (mp != null && !mp.access().isEmpty()) {
                property.setAccess(mp.access());
            }
            if ((required = md.getRequired()) != null) {
                property.setRequired(required.booleanValue());
            }
            if ((description = this._intr.findPropertyDescription((Annotated)member2)) != null && !"".equals(description)) {
                property.setDescription(description);
            }
            if ((index = this._intr.findPropertyIndex((Annotated)member2)) != null) {
                property.setPosition(index);
            }
            property.setDefault(this._findDefaultValue((Annotated)member2));
            property.setExample(this._findExampleValue((Annotated)member2));
            property.setReadOnly(this._findReadOnly((Annotated)member2));
            if (property.getReadOnly() == null && isReadOnly.booleanValue()) {
                property.setReadOnly(isReadOnly);
            }
            if (mp != null && (allowableValues = AllowableValuesUtils.create(mp.allowableValues())) != null) {
                Map<PropertyBuilder.PropertyId, Object> args = allowableValues.asPropertyArguments();
                PropertyBuilder.merge((Property)property, args);
            }
            JAXBAnnotationsHelper.apply(member2, property);
            this.applyBeanValidatorAnnotations((Property)property, annotations);
            props.add((Property)property);
        }
        if (!this.resolveSubtypes(model, beanDesc, context)) {
            model.setDiscriminator(null);
        }
        Collections.sort(props, ModelResolver.getPropertyComparator());
        LinkedHashMap<String, Property> modelProps = new LinkedHashMap<String, Property>();
        for (Property prop : props) {
            modelProps.put(prop.getName(), prop);
        }
        model.setProperties(modelProps);
        return model;
    }

    protected void applyBeanValidatorAnnotations(Property property, Annotation[] annotations) {
        Max max;
        Min min;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            for (Annotation anno : annotations) {
                annos.put(anno.annotationType().getName(), anno);
            }
        }
        if (annos.containsKey("javax.validation.constraints.NotNull")) {
            property.setRequired(true);
        }
        if (annos.containsKey("javax.validation.constraints.Min") && property instanceof AbstractNumericProperty) {
            min = (Min)annos.get("javax.validation.constraints.Min");
            AbstractNumericProperty ap = (AbstractNumericProperty)property;
            ap.setMinimum(new Double(min.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Max") && property instanceof AbstractNumericProperty) {
            max = (Max)annos.get("javax.validation.constraints.Max");
            AbstractNumericProperty ap = (AbstractNumericProperty)property;
            ap.setMaximum(new Double(max.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Size")) {
            Size size = (Size)annos.get("javax.validation.constraints.Size");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                ap.setMinimum(new Double(size.min()));
                ap.setMaximum(new Double(size.max()));
            }
            if (property instanceof StringProperty) {
                StringProperty sp = (StringProperty)property;
                sp.minLength(new Integer(size.min()));
                sp.maxLength(new Integer(size.max()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMin")) {
            min = (DecimalMin)annos.get("javax.validation.constraints.DecimalMin");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                if (min.inclusive()) {
                    ap.setMinimum(new Double(min.value()));
                } else {
                    ap.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
                }
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMax")) {
            max = (DecimalMax)annos.get("javax.validation.constraints.DecimalMax");
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty ap = (AbstractNumericProperty)property;
                if (max.inclusive()) {
                    ap.setMaximum(new Double(max.value()));
                } else {
                    ap.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
                }
            }
        }
    }

    protected JavaType getInnerType(String innerType) {
        try {
            Class<?> innerClass = Class.forName(innerType);
            if (innerClass != null) {
                TypeFactory tf = this._mapper.getTypeFactory();
                return tf.constructType(innerClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean resolveSubtypes(ModelImpl model, BeanDescription bean, ModelConverterContext context) {
        List types = this._intr.findSubtypes((Annotated)bean.getClassInfo());
        if (types == null) {
            return false;
        }
        int count = 0;
        Class beanClass = bean.getClassInfo().getAnnotated();
        for (NamedType subtype : types) {
            Model subtypeModel;
            if (!beanClass.isAssignableFrom(subtype.getType()) || !((subtypeModel = context.resolve(subtype.getType())) instanceof ModelImpl)) continue;
            ModelImpl impl = (ModelImpl)subtypeModel;
            Map baseProps = model.getProperties();
            Map subtypeProps = impl.getProperties();
            if (baseProps != null && subtypeProps != null) {
                for (String remove : baseProps.keySet()) {
                    subtypeProps.remove(remove);
                }
            }
            impl.setDiscriminator(null);
            ComposedModel child = new ComposedModel().parent((Model)new RefModel(model.getName())).child((Model)impl);
            context.defineModel(impl.getName(), (Model)child);
            ++count;
        }
        return count != 0;
    }
}

