/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.thrift.util.mem;

import com.thinkaurelius.thrift.util.mem.Memory;
import com.thinkaurelius.thrift.util.mem.TMemoryInputTransport;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;

public abstract class Buffer {
    protected ByteBuffer buffer;

    public static Buffer allocate(int size, boolean onHeapAllocation) {
        return onHeapAllocation ? new OnHeapBuffer(size) : new OffHeapBuffer(size);
    }

    protected void setBuffer(ByteBuffer newBuffer) {
        this.buffer = newBuffer;
    }

    protected void setBuffer(ByteBuffer newBuffer, ByteOrder order) {
        this.setBuffer(newBuffer);
        if (this.buffer != null) {
            this.buffer.order(order);
        }
    }

    public void clear() {
        this.buffer.clear();
    }

    public int getInt(int atIndex) {
        return this.buffer.getInt(atIndex);
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }

    public void put(int index, byte value) {
        this.buffer.put(index, value);
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public int size() {
        return this.buffer.capacity();
    }

    public abstract void reallocate(int var1);

    public abstract void free();

    public TTransport getInputTransport() {
        return new TMemoryInputTransport(this.buffer);
    }

    public int readFrom(TNonblockingTransport transport) throws IOException {
        return transport.read(this.buffer);
    }

    public int writeTo(TNonblockingTransport transport, int start, int count) throws IOException {
        ByteBuffer dup = this.buffer.duplicate();
        dup.position(start).limit(start + count);
        return transport.write(dup);
    }

    private static class OnHeapBuffer
    extends Buffer {
        public OnHeapBuffer(int size) {
            this.setBuffer(ByteBuffer.allocate(size));
        }

        @Override
        public void reallocate(int newSize) {
            assert (this.buffer.hasArray());
            if (newSize < this.buffer.capacity()) {
                this.buffer.clear().limit(newSize);
                return;
            }
            if (this.buffer.capacity() == newSize) {
                return;
            }
            ByteBuffer extended = ByteBuffer.allocate(newSize);
            System.arraycopy(this.buffer.array(), 0, extended.array(), 0, this.buffer.capacity());
            this.setBuffer(extended);
        }

        @Override
        public void free() {
            this.setBuffer(null);
        }
    }

    private static class OffHeapBuffer
    extends Buffer {
        private final Memory rawMemory;

        public OffHeapBuffer(int size) {
            this.rawMemory = Memory.allocate(size);
            this.setBuffer(this.rawMemory, ByteOrder.BIG_ENDIAN);
        }

        @Override
        public void reallocate(int newSize) {
            this.setBuffer(this.rawMemory.reallocate(newSize), ByteOrder.BIG_ENDIAN);
        }

        @Override
        public void free() {
            if (this.rawMemory.getPeer() != 0L) {
                this.rawMemory.free();
            }
            this.setBuffer(null);
        }

        private void setBuffer(Memory memory, ByteOrder order) {
            this.setBuffer(memory.toByteBuffer(), order);
        }
    }
}

