/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.addthis.metrics3.reporter.config.ReporterConfig;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnectorServer;
import org.apache.cassandra.batchlog.LegacyBatchlogMigrator;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SizeEstimatesRecorder;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.WindowsFailedSnapshotTracker;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.StartupException;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.hints.LegacyHintsMigrator;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.schema.LegacySchemaMigrator;
import org.apache.cassandra.security.ThreadAwareSecurityManager;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.DefaultFSErrorHandler;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.NativeAccessMBean;
import org.apache.cassandra.service.NativeTransportService;
import org.apache.cassandra.service.StartupChecks;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ThriftServer;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JMXServerUtils;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.Mx4jTool;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.WindowsTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=NativeAccess";
    private static final Logger logger;
    static final CassandraDaemon instance;
    public Server thriftServer;
    private NativeTransportService nativeTransportService;
    private JMXConnectorServer jmxServer;
    private final boolean runManaged;
    protected final StartupChecks startupChecks;
    private boolean setupCompleted;

    private void maybeInitJmx() {
        if (System.getProperty("com.sun.management.jmxremote.port") != null) {
            logger.warn("JMX settings in cassandra-env.sh have been bypassed as the JMX connector server is already initialized. Please refer to cassandra-env.(sh|ps1) for JMX configuration info");
            return;
        }
        System.setProperty("java.rmi.server.randomIDs", "true");
        boolean localOnly = false;
        String jmxPort = System.getProperty("cassandra.jmx.remote.port");
        if (jmxPort == null) {
            localOnly = true;
            jmxPort = System.getProperty("cassandra.jmx.local.port");
        }
        if (jmxPort == null) {
            return;
        }
        try {
            this.jmxServer = JMXServerUtils.createJMXServer(Integer.parseInt(jmxPort), localOnly);
            if (this.jmxServer == null) {
                return;
            }
        }
        catch (IOException e) {
            this.exitOrFail(1, e.getMessage(), e.getCause());
        }
    }

    public CassandraDaemon() {
        this(false);
    }

    public CassandraDaemon(boolean runManaged) {
        this.runManaged = runManaged;
        this.startupChecks = new StartupChecks().withDefaultTests();
        this.setupCompleted = false;
    }

    protected void setup() {
        FileUtils.setFSErrorHandler(new DefaultFSErrorHandler());
        if (FBUtilities.isWindows) {
            WindowsFailedSnapshotTracker.deleteOldSnapshots();
        }
        this.maybeInitJmx();
        Mx4jTool.maybeLoad();
        ThreadAwareSecurityManager.install();
        this.logSystemInfo();
        NativeLibrary.tryMlockall();
        try {
            this.startupChecks.verify();
        }
        catch (StartupException e) {
            this.exitOrFail(e.returnCode, e.getMessage(), e.getCause());
        }
        try {
            if (SystemKeyspace.snapshotOnVersionChange()) {
                SystemKeyspace.migrateDataDirs();
            }
        }
        catch (IOException e) {
            this.exitOrFail(3, e.getMessage(), e.getCause());
        }
        SystemKeyspace.persistLocalMetadata();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StorageMetrics.exceptions.inc();
                logger.error("Exception in thread " + t, e);
                Tracing.trace("Exception in thread {}", (Object)t, (Object)e);
                for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
                    JVMStabilityInspector.inspectThrowable(e2);
                    if (e2 instanceof FSError) {
                        if (e2 != e) {
                            logger.error("Exception in thread " + t, e2);
                        }
                        FileUtils.handleFSError((FSError)e2);
                    }
                    if (!(e2 instanceof CorruptSSTableException)) continue;
                    if (e2 != e) {
                        logger.error("Exception in thread " + t, e2);
                    }
                    FileUtils.handleCorruptSSTable((CorruptSSTableException)e2);
                }
            }
        });
        LegacySchemaMigrator.migrate();
        StorageService.instance.populateTokenMetadata();
        Schema.instance.loadFromDisk();
        for (String keyspaceName : Schema.instance.getKeyspaces()) {
            if (keyspaceName.equals("system")) continue;
            for (CFMetaData cfm : Schema.instance.getTablesAndViews(keyspaceName)) {
                try {
                    ColumnFamilyStore.scrubDataDirectories(cfm);
                }
                catch (StartupException e) {
                    this.exitOrFail(e.returnCode, e.getMessage(), e.getCause());
                }
            }
        }
        Keyspace.setInitialized();
        for (String keyspaceName : Schema.instance.getKeyspaces()) {
            if (logger.isDebugEnabled()) {
                logger.debug("opening keyspace {}", (Object)keyspaceName);
            }
            for (ColumnFamilyStore cfs : Keyspace.open(keyspaceName).getColumnFamilyStores()) {
                for (ColumnFamilyStore columnFamilyStore : cfs.concatWithIndexes()) {
                    columnFamilyStore.disableAutoCompaction();
                }
            }
        }
        try {
            this.loadRowAndKeyCacheAsync().get();
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            logger.warn("Error loading key or row cache", t);
        }
        try {
            GCInspector.register();
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            logger.warn("Unable to start GCInspector (currently only supported on the Sun JVM)");
        }
        try {
            CommitLog.instance.recoverSegmentsOnDisk();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StorageService.instance.populateTokenMetadata();
        new LegacyHintsMigrator(DatabaseDescriptor.getHintsDirectory(), DatabaseDescriptor.getMaxHintsFileSize()).migrate();
        LegacyBatchlogMigrator.migrate();
        SystemKeyspace.finishStartup();
        StorageService.instance.cleanupSizeEstimates();
        int sizeRecorderInterval = Integer.getInteger("cassandra.size_recorder_interval", 300);
        if (sizeRecorderInterval > 0) {
            ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(SizeEstimatesRecorder.instance, 30L, sizeRecorderInterval, TimeUnit.SECONDS);
        }
        QueryProcessor.preloadPreparedStatement();
        String metricsReporterConfigFile = System.getProperty("cassandra.metricsReporterConfigFile");
        if (metricsReporterConfigFile != null) {
            logger.info("Trying to load metrics-reporter-config from file: {}", (Object)metricsReporterConfigFile);
            try {
                CassandraMetricsRegistry.Metrics.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
                CassandraMetricsRegistry.Metrics.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
                CassandraMetricsRegistry.Metrics.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
                CassandraMetricsRegistry.Metrics.register("jvm.fd.usage", (Metric)new FileDescriptorRatioGauge());
                URL resource = CassandraDaemon.class.getClassLoader().getResource(metricsReporterConfigFile);
                if (resource == null) {
                    logger.warn("Failed to load metrics-reporter-config, file does not exist: {}", (Object)metricsReporterConfigFile);
                } else {
                    String reportFileLocation = resource.getFile();
                    ReporterConfig.loadFromFile((String)reportFileLocation).enableAll((MetricRegistry)CassandraMetricsRegistry.Metrics);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to load metrics-reporter-config, metric sinks will not be activated", (Throwable)e);
            }
        }
        StorageService.instance.registerDaemon(this);
        try {
            StorageService.instance.initServer();
        }
        catch (ConfigurationException e) {
            System.err.println(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            this.exitOrFail(1, "Fatal configuration error", e);
        }
        Runnable viewRebuild = () -> {
            for (Keyspace keyspace : Keyspace.all()) {
                keyspace.viewManager.buildAllViews();
            }
            logger.debug("Completed submission of build tasks for any materialized views defined at startup");
        };
        ScheduledExecutors.optionalTasks.schedule(viewRebuild, (long)StorageService.RING_DELAY, TimeUnit.MILLISECONDS);
        if (!FBUtilities.getBroadcastAddress().equals(InetAddress.getLoopbackAddress())) {
            Gossiper.waitToSettle();
        }
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.reload();
                    if (!store.getCompactionStrategyManager().shouldBeEnabled()) continue;
                    store.enableAutoCompaction();
                }
            }
        }
        ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(ColumnFamilyStore.getBackgroundCompactionTaskSubmitter(), 5L, 1L, TimeUnit.MINUTES);
        InetAddress rpcAddr = DatabaseDescriptor.getRpcAddress();
        int rpcPort = DatabaseDescriptor.getRpcPort();
        int n = DatabaseDescriptor.getRpcListenBacklog();
        this.thriftServer = new ThriftServer(rpcAddr, rpcPort, n);
        this.nativeTransportService = new NativeTransportService();
        this.completeSetup();
    }

    private ListenableFuture<?> loadRowAndKeyCacheAsync() {
        ListenableFuture<Integer> keyCacheLoad = CacheService.instance.keyCache.loadSavedAsync();
        ListenableFuture<Integer> rowCacheLoad = CacheService.instance.rowCache.loadSavedAsync();
        ListenableFuture retval = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{keyCacheLoad, rowCacheLoad});
        return retval;
    }

    @VisibleForTesting
    public void completeSetup() {
        this.setupCompleted = true;
    }

    public boolean setupCompleted() {
        return this.setupCompleted;
    }

    private void logSystemInfo() {
        if (logger.isInfoEnabled()) {
            try {
                logger.info("Hostname: {}", (Object)InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e1) {
                logger.info("Could not resolve local host");
            }
            logger.info("JVM vendor/version: {}/{}", (Object)System.getProperty("java.vm.name"), (Object)System.getProperty("java.version"));
            logger.info("Heap size: {}/{}", (Object)FBUtilities.prettyPrintMemory(Runtime.getRuntime().totalMemory()), (Object)FBUtilities.prettyPrintMemory(Runtime.getRuntime().maxMemory()));
            for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                logger.info("{} {}: {}", new Object[]{pool.getName(), pool.getType(), pool.getPeakUsage()});
            }
            logger.info("Classpath: {}", (Object)System.getProperty("java.class.path"));
            logger.info("JVM Arguments: {}", ManagementFactory.getRuntimeMXBean().getInputArguments());
        }
    }

    public void init(String[] arguments) throws IOException {
        this.setup();
    }

    public void start() {
        String nativeFlag;
        if (StorageService.instance.hasJoined()) {
            if (StorageService.instance.isSurveyMode()) {
                if (StorageService.instance.isBootstrapMode() || DatabaseDescriptor.getAuthenticator().requireAuthentication()) {
                    logger.info("Not starting client transports in write_survey mode as it's bootstrapping or auth is enabled");
                    return;
                }
            } else if (!SystemKeyspace.bootstrapComplete()) {
                logger.info("Not starting client transports as bootstrap has not completed");
                return;
            }
        }
        if ((nativeFlag = System.getProperty("cassandra.start_native_transport")) != null && Boolean.parseBoolean(nativeFlag) || nativeFlag == null && DatabaseDescriptor.startNativeTransport()) {
            this.startNativeTransport();
            StorageService.instance.setRpcReady(true);
        } else {
            logger.info("Not starting native transport as requested. Use JMX (StorageService->startNativeTransport()) or nodetool (enablebinary) to start it");
        }
        String rpcFlag = System.getProperty("cassandra.start_rpc");
        if (rpcFlag != null && Boolean.parseBoolean(rpcFlag) || rpcFlag == null && DatabaseDescriptor.startRpc()) {
            this.thriftServer.start();
        } else {
            logger.info("Not starting RPC server as requested. Use JMX (StorageService->startRPCServer()) or nodetool (enablethrift) to start it");
        }
    }

    public void stop() {
        logger.info("Cassandra shutting down...");
        if (this.thriftServer != null) {
            this.thriftServer.stop();
        }
        if (this.nativeTransportService != null) {
            this.nativeTransportService.destroy();
        }
        StorageService.instance.setRpcReady(false);
        if (FBUtilities.isWindows) {
            System.exit(0);
        }
        if (this.jmxServer != null) {
            try {
                this.jmxServer.stop();
            }
            catch (IOException e) {
                logger.error("Error shutting down local JMX server: ", (Throwable)e);
            }
        }
    }

    public void destroy() {
    }

    public void activate() {
        try {
            this.applyConfig();
            MBeanWrapper.instance.registerMBean((Object)new StandardMBean(new NativeAccess(), NativeAccessMBean.class), MBEAN_NAME, MBeanWrapper.OnException.LOG);
            if (FBUtilities.isWindows) {
                WindowsTimer.startTimerPeriod(DatabaseDescriptor.getWindowsTimerInterval());
            }
            this.setup();
            String pidFile = System.getProperty("cassandra-pidfile");
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            this.start();
        }
        catch (Throwable e) {
            boolean logStackTrace = e instanceof ConfigurationException ? ((ConfigurationException)e).logStackTrace : true;
            System.out.println("Exception (" + e.getClass().getName() + ") encountered during startup: " + e.getMessage());
            if (logStackTrace) {
                if (this.runManaged) {
                    logger.error("Exception encountered during startup", e);
                }
                e.printStackTrace();
                this.exitOrFail(3, "Exception encountered during startup", e);
            }
            if (this.runManaged) {
                logger.error("Exception encountered during startup: {}", (Object)e.getMessage());
            }
            System.err.println(e.getMessage());
            this.exitOrFail(3, "Exception encountered during startup: " + e.getMessage());
        }
    }

    public void applyConfig() {
        DatabaseDescriptor.daemonInitialization();
    }

    public void startNativeTransport() {
        if (StorageService.instance.hasJoined()) {
            if (StorageService.instance.isSurveyMode()) {
                if (StorageService.instance.isBootstrapMode() || DatabaseDescriptor.getAuthenticator().requireAuthentication()) {
                    throw new IllegalStateException("Not starting client transports in write_survey mode as it's bootstrapping or auth is enabled");
                }
            } else if (!SystemKeyspace.bootstrapComplete()) {
                throw new IllegalStateException("Node is not yet bootstrapped completely. Use nodetool to check bootstrap state and resume. For more, see `nodetool help bootstrap`");
            }
        }
        if (this.nativeTransportService == null) {
            throw new IllegalStateException("setup() must be called first for CassandraDaemon");
        }
        this.nativeTransportService.start();
    }

    public void stopNativeTransport() {
        if (this.nativeTransportService != null) {
            this.nativeTransportService.stop();
        }
    }

    public boolean isNativeTransportRunning() {
        return this.nativeTransportService != null ? this.nativeTransportService.isRunning() : false;
    }

    public void deactivate() {
        this.stop();
        this.destroy();
        if (!this.runManaged) {
            System.exit(0);
        }
    }

    public static void stop(String[] args) {
        instance.deactivate();
    }

    public static void main(String[] args) {
        instance.activate();
    }

    private void exitOrFail(int code, String message) {
        this.exitOrFail(code, message, null);
    }

    private void exitOrFail(int code, String message, Throwable cause) {
        if (this.runManaged) {
            RuntimeException t = cause != null ? new RuntimeException(message, cause) : new RuntimeException(message);
            throw t;
        }
        logger.error(message, cause);
        System.exit(code);
    }

    static {
        SharedMetricRegistries.getOrCreate((String)"logback-metrics").addListener((MetricRegistryListener)new MetricRegistryListener.Base(){

            public void onMeterAdded(String metricName, Meter meter) {
                int separator = metricName.lastIndexOf(46);
                String appenderName = metricName.substring(0, separator);
                String metric = metricName.substring(separator + 1);
                ObjectName name = DefaultNameFactory.createMetricName(appenderName, metric, null).getMBeanName();
                CassandraMetricsRegistry.Metrics.registerMBean((Metric)meter, name);
            }
        });
        logger = LoggerFactory.getLogger(CassandraDaemon.class);
        instance = new CassandraDaemon();
    }

    public static interface Server {
        public void start();

        public void stop();

        public boolean isRunning();
    }

    static class NativeAccess
    implements NativeAccessMBean {
        NativeAccess() {
        }

        @Override
        public boolean isAvailable() {
            return NativeLibrary.isAvailable();
        }

        @Override
        public boolean isMemoryLockable() {
            return NativeLibrary.jnaMemoryLockable();
        }
    }
}

