/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.driver.core.TableMetadata;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.EmbeddedCassandraConnectorTestBase;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.SchemaHolder;
import io.debezium.connector.cassandra.SchemaProcessor;
import org.junit.Assert;
import org.junit.Test;

public class SchemaProcessorTest
extends EmbeddedCassandraConnectorTestBase {
    @Test
    public void testProcess() throws Exception {
        CassandraConnectorContext context = SchemaProcessorTest.generateTaskContext();
        SchemaProcessor schemaProcessor = new SchemaProcessor(context);
        String namespacePrefix = "io.debezium.connector.cassandra.test_topic.test_keyspace";
        Assert.assertEquals((long)0L, (long)context.getSchemaHolder().getCdcEnabledTableMetadataSet().size());
        context.getCassandraClient().execute("CREATE TABLE IF NOT EXISTS " + SchemaProcessorTest.keyspaceTable("table1") + " (a int, b text, PRIMARY KEY(a)) WITH cdc = false;");
        schemaProcessor.process();
        Assert.assertEquals((long)0L, (long)context.getSchemaHolder().getCdcEnabledTableMetadataSet().size());
        Assert.assertNull((Object)context.getSchemaHolder().getOrUpdateKeyValueSchema(new KeyspaceTable("test_keyspace", "table1")));
        context.getCassandraClient().execute("ALTER TABLE " + SchemaProcessorTest.keyspaceTable("table1") + " WITH cdc = true;");
        schemaProcessor.process();
        Assert.assertEquals((long)1L, (long)context.getSchemaHolder().getCdcEnabledTableMetadataSet().size());
        SchemaHolder.KeyValueSchema keyValueSchema = context.getSchemaHolder().getOrUpdateKeyValueSchema(new KeyspaceTable("test_keyspace", "table1"));
        Assert.assertNotNull((Object)keyValueSchema);
        String expectedKeySchemaName = namespacePrefix + ".table1.Key";
        Assert.assertEquals((Object)expectedKeySchemaName, (Object)keyValueSchema.keySchema().name());
        String expectedValueSchemaName = namespacePrefix + ".table1.Value";
        Assert.assertEquals((Object)expectedValueSchemaName, (Object)keyValueSchema.valueSchema().name());
        context.getCassandraClient().execute("CREATE TABLE IF NOT EXISTS " + SchemaProcessorTest.keyspaceTable("table2") + " (a int, b text, PRIMARY KEY(a)) WITH cdc = true;");
        schemaProcessor.process();
        Assert.assertEquals((long)2L, (long)context.getSchemaHolder().getCdcEnabledTableMetadataSet().size());
        keyValueSchema = context.getSchemaHolder().getOrUpdateKeyValueSchema(new KeyspaceTable("test_keyspace", "table1"));
        Assert.assertNotNull((Object)keyValueSchema);
        expectedKeySchemaName = namespacePrefix + ".table1.Key";
        Assert.assertEquals((Object)expectedKeySchemaName, (Object)keyValueSchema.keySchema().name());
        expectedValueSchemaName = namespacePrefix + ".table1.Value";
        Assert.assertEquals((Object)expectedValueSchemaName, (Object)keyValueSchema.valueSchema().name());
        keyValueSchema = context.getSchemaHolder().getOrUpdateKeyValueSchema(new KeyspaceTable("test_keyspace", "table2"));
        Assert.assertNotNull((Object)keyValueSchema);
        expectedKeySchemaName = namespacePrefix + ".table2.Key";
        Assert.assertEquals((Object)expectedKeySchemaName, (Object)keyValueSchema.keySchema().name());
        expectedValueSchemaName = namespacePrefix + ".table2.Value";
        Assert.assertEquals((Object)expectedValueSchemaName, (Object)keyValueSchema.valueSchema().name());
        context.getCassandraClient().execute("ALTER TABLE " + SchemaProcessorTest.keyspaceTable("table2") + " ADD c text");
        schemaProcessor.process();
        Assert.assertEquals((long)2L, (long)context.getSchemaHolder().getCdcEnabledTableMetadataSet().size());
        TableMetadata expectedTm1 = context.getCassandraClient().getCdcEnabledTableMetadata("test_keyspace", "table1");
        TableMetadata expectedTm2 = context.getCassandraClient().getCdcEnabledTableMetadata("test_keyspace", "table2");
        TableMetadata tm1 = context.getSchemaHolder().getOrUpdateKeyValueSchema(new KeyspaceTable("test_keyspace", "table1")).tableMetadata();
        TableMetadata tm2 = context.getSchemaHolder().getOrUpdateKeyValueSchema(new KeyspaceTable("test_keyspace", "table2")).tableMetadata();
        Assert.assertEquals((Object)expectedTm1, (Object)tm1);
        Assert.assertEquals((Object)expectedTm2, (Object)tm2);
        SchemaProcessorTest.deleteTestKeyspaceTables();
        context.cleanUp();
    }
}

