/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.avro;

import io.confluent.connect.avro.AvroConverterConfig;
import io.confluent.connect.avro.AvroData;
import io.confluent.connect.avro.AvroDataConfig;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.AvroSchemaUtils;
import io.confluent.kafka.serializers.GenericContainerWithVersion;
import io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.util.Map;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;

public class AvroConverter
implements Converter {
    private SchemaRegistryClient schemaRegistry;
    private Serializer serializer;
    private Deserializer deserializer;
    private boolean isKey;
    private AvroData avroData;

    public AvroConverter() {
    }

    public AvroConverter(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        AvroConverterConfig avroConverterConfig = new AvroConverterConfig(configs);
        if (this.schemaRegistry == null) {
            this.schemaRegistry = new CachedSchemaRegistryClient(avroConverterConfig.getSchemaRegistryUrls(), avroConverterConfig.getMaxSchemasPerSubject(), configs, avroConverterConfig.requestHeaders());
        }
        this.serializer = new Serializer(configs, this.schemaRegistry);
        this.deserializer = new Deserializer(configs, this.schemaRegistry);
        this.avroData = new AvroData(new AvroDataConfig(configs));
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        try {
            return this.serializer.serialize(topic, this.isKey, this.avroData.fromConnectData(schema, value));
        }
        catch (SerializationException e) {
            throw new DataException(String.format("Failed to serialize Avro data from topic %s :", topic), (Throwable)e);
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        try {
            GenericContainerWithVersion containerWithVersion = this.deserializer.deserialize(topic, this.isKey, value);
            if (containerWithVersion == null) {
                return SchemaAndValue.NULL;
            }
            GenericContainer deserialized = containerWithVersion.container();
            Integer version = containerWithVersion.version();
            if (deserialized instanceof IndexedRecord) {
                return this.avroData.toConnectData(deserialized.getSchema(), (Object)deserialized, version);
            }
            if (deserialized instanceof NonRecordContainer) {
                return this.avroData.toConnectData(deserialized.getSchema(), ((NonRecordContainer)deserialized).getValue(), version);
            }
            throw new DataException(String.format("Unsupported type returned during deserialization of topic %s ", topic));
        }
        catch (SerializationException e) {
            throw new DataException(String.format("Failed to deserialize data for topic %s to Avro: ", topic), (Throwable)e);
        }
    }

    private static class Deserializer
    extends AbstractKafkaAvroDeserializer {
        public Deserializer(SchemaRegistryClient client) {
            this.schemaRegistry = client;
        }

        public Deserializer(Map<String, ?> configs, SchemaRegistryClient client) {
            this(client);
            this.configure(new KafkaAvroDeserializerConfig(configs));
        }

        public GenericContainerWithVersion deserialize(String topic, boolean isKey, byte[] payload) {
            return this.deserializeWithSchemaAndVersion(topic, isKey, payload);
        }
    }

    private static class Serializer
    extends AbstractKafkaAvroSerializer {
        public Serializer(SchemaRegistryClient client, boolean autoRegisterSchema) {
            this.schemaRegistry = client;
            this.autoRegisterSchema = autoRegisterSchema;
        }

        public Serializer(Map<String, ?> configs, SchemaRegistryClient client) {
            this(client, false);
            this.configure(new KafkaAvroSerializerConfig(configs));
        }

        public byte[] serialize(String topic, boolean isKey, Object value) {
            return this.serializeImpl(this.getSubjectName(topic, isKey, value, AvroSchemaUtils.getSchema((Object)value)), value);
        }
    }
}

