/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.converter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UserType;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.TypeConverter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.db.marshal.UTF8Type;

public class UserTypeConverter
implements TypeConverter<org.apache.cassandra.db.marshal.UserType> {
    @Override
    public org.apache.cassandra.db.marshal.UserType convert(DataType dataType) {
        UserType userType = (UserType)dataType;
        List innerTypes = dataType.getTypeArguments();
        ArrayList innerAbstractTypes = new ArrayList(innerTypes.size());
        for (DataType dt : innerTypes) {
            innerAbstractTypes.add(CassandraTypeConverter.convert(dt));
        }
        String typeNameString = userType.getTypeName();
        Collection fieldNames = userType.getFieldNames();
        ByteBuffer typeNameBuffer = UTF8Type.instance.fromString(typeNameString);
        ArrayList<FieldIdentifier> fieldIdentifiers = new ArrayList<FieldIdentifier>(fieldNames.size());
        for (String fieldName : fieldNames) {
            fieldIdentifiers.add(FieldIdentifier.forInternalString((String)fieldName));
        }
        return new org.apache.cassandra.db.marshal.UserType(userType.getKeyspace(), typeNameBuffer, fieldIdentifiers, innerAbstractTypes, !userType.isFrozen());
    }
}

