/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;

public class KafkaConsumerMetrics {
    private final Metrics metrics;
    private Sensor timeBetweenPollSensor;
    private Sensor pollIdleSensor;
    private long lastPollMs;
    private long pollStartMs;
    private long timeSinceLastPollMs;

    public KafkaConsumerMetrics(Metrics metrics, String metricGrpPrefix) {
        this.metrics = metrics;
        String metricGroupName = metricGrpPrefix + "-metrics";
        Measurable lastPoll = (mConfig, now) -> {
            if (this.lastPollMs == 0L) {
                return -1.0;
            }
            return TimeUnit.SECONDS.convert(now - this.lastPollMs, TimeUnit.MILLISECONDS);
        };
        metrics.addMetric(metrics.metricName("last-poll-seconds-ago", metricGroupName, "The number of seconds since the last poll() invocation."), lastPoll);
        this.timeBetweenPollSensor = metrics.sensor("time-between-poll");
        this.timeBetweenPollSensor.add(metrics.metricName("time-between-poll-avg", metricGroupName, "The average delay between invocations of poll()."), new Avg());
        this.timeBetweenPollSensor.add(metrics.metricName("time-between-poll-max", metricGroupName, "The max delay between invocations of poll()."), new Max());
        this.pollIdleSensor = metrics.sensor("poll-idle-ratio-avg");
        this.pollIdleSensor.add(metrics.metricName("poll-idle-ratio-avg", metricGroupName, "The average fraction of time the consumer's poll() is idle as opposed to waiting for the user code to process records."), new Avg());
    }

    public void recordPollStart(long pollStartMs) {
        this.pollStartMs = pollStartMs;
        this.timeSinceLastPollMs = this.lastPollMs != 0L ? pollStartMs - this.lastPollMs : 0L;
        this.timeBetweenPollSensor.record(this.timeSinceLastPollMs);
        this.lastPollMs = pollStartMs;
    }

    public void recordPollEnd(long pollEndMs) {
        long pollTimeMs = pollEndMs - this.pollStartMs;
        double pollIdleRatio = (double)pollTimeMs * 1.0 / (double)(pollTimeMs + this.timeSinceLastPollMs);
        this.pollIdleSensor.record(pollIdleRatio);
    }
}

