/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.Module;
import io.debezium.connector.cassandra.OffsetPosition;
import io.debezium.time.Conversions;
import java.time.Instant;
import java.util.HashMap;
import java.util.Objects;

public class SourceInfo
extends AbstractSourceInfo {
    public static final String CLUSTER_KEY = "cluster";
    public static final String COMMITLOG_FILENAME_KEY = "file";
    public static final String COMMITLOG_POSITION_KEY = "pos";
    public static final String KEYSPACE_NAME_KEY = "keyspace";
    public static final String TABLE_NAME_KEY = "table";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final String TIMESTAMP_KEY = "ts_micro";
    public final String version = Module.version();
    public final String connector = Module.name();
    public String cluster;
    public OffsetPosition offsetPosition;
    public KeyspaceTable keyspaceTable;
    public boolean snapshot;
    public Instant tsMicro;

    public SourceInfo(CommonConnectorConfig config) {
        super(config);
    }

    public void update(String cluster, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable, boolean snapshot, Instant tsMicro) {
        this.cluster = cluster;
        this.offsetPosition = offsetPosition;
        this.keyspaceTable = keyspaceTable;
        this.tsMicro = tsMicro;
        this.snapshot = snapshot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SourceInfo that = (SourceInfo)((Object)o);
        return this.version.equals(that.version) && this.connector.equals(that.connector) && this.cluster.equals(that.cluster) && this.offsetPosition == that.offsetPosition && this.snapshot == that.snapshot && this.keyspaceTable == that.keyspaceTable && this.tsMicroInLong() == that.tsMicroInLong();
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.snapshot, this.offsetPosition, this.keyspaceTable, this.tsMicroInLong());
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", this.version);
        map.put("connector", this.connector);
        map.put(CLUSTER_KEY, this.cluster);
        map.put(SNAPSHOT_KEY, this.snapshot);
        map.put(COMMITLOG_FILENAME_KEY, this.offsetPosition.fileName);
        map.put(COMMITLOG_POSITION_KEY, this.offsetPosition.filePosition);
        map.put(KEYSPACE_NAME_KEY, this.keyspaceTable.keyspace);
        map.put(TABLE_NAME_KEY, this.keyspaceTable.table);
        map.put(TIMESTAMP_KEY, this.tsMicroInLong());
        return ((Object)map).toString();
    }

    protected Instant timestamp() {
        return this.tsMicro;
    }

    protected long tsMicroInLong() {
        return Conversions.toEpochMicros((Instant)this.tsMicro);
    }

    protected SnapshotRecord snapshot() {
        return this.snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE;
    }

    protected String database() {
        return "NULL";
    }
}

