/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.ChangeRecord;
import io.debezium.connector.cassandra.FieldFilterSelector;
import io.debezium.connector.cassandra.Filters;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.RowData;
import io.debezium.connector.cassandra.SourceInfo;
import io.debezium.connector.cassandra.TombstoneRecord;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Schema;

public class RecordMaker {
    private final boolean emitTombstoneOnDelete;
    private final Filters filters;
    private final SourceInfo sourceInfo;

    public RecordMaker(boolean emitTombstoneOnDelete, Filters filters, SourceInfo sourceInfo) {
        this.emitTombstoneOnDelete = emitTombstoneOnDelete;
        this.filters = filters;
        this.sourceInfo = sourceInfo;
    }

    public void insert(RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, Consumer<Record> consumer) {
        this.createRecord(data, keySchema, valueSchema, markOffset, consumer, Record.Operation.INSERT);
    }

    public void update(RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, Consumer<Record> consumer) {
        this.createRecord(data, keySchema, valueSchema, markOffset, consumer, Record.Operation.UPDATE);
    }

    public void delete(RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, Consumer<Record> consumer) {
        this.createRecord(data, keySchema, valueSchema, markOffset, consumer, Record.Operation.DELETE);
    }

    private void createRecord(RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, Consumer<Record> consumer, Record.Operation operation) {
        RowData filteredData;
        FieldFilterSelector.FieldFilter fieldFilter = this.filters.getFieldFilter(this.sourceInfo.keyspaceTable);
        switch (operation) {
            case INSERT: 
            case UPDATE: {
                filteredData = fieldFilter.apply(data);
                break;
            }
            default: {
                filteredData = data;
            }
        }
        ChangeRecord record = new ChangeRecord(this.sourceInfo, filteredData, keySchema, valueSchema, operation, markOffset);
        consumer.accept(record);
        if (operation == Record.Operation.DELETE && this.emitTombstoneOnDelete) {
            TombstoneRecord tombstoneRecord = new TombstoneRecord(this.sourceInfo, filteredData, keySchema);
            consumer.accept(tombstoneRecord);
        }
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }
}

