/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.ConfigurationDefaults;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.Column;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationalSnapshotChangeEventSource
implements SnapshotChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalSnapshotChangeEventSource.class);
    private static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
    private final RelationalDatabaseConnectorConfig connectorConfig;
    private final OffsetContext previousOffset;
    private final JdbcConnection jdbcConnection;
    private final HistorizedRelationalDatabaseSchema schema;
    private final EventDispatcher<TableId> dispatcher;
    protected final Clock clock;
    private final SnapshotProgressListener snapshotProgressListener;

    public RelationalSnapshotChangeEventSource(RelationalDatabaseConnectorConfig connectorConfig, OffsetContext previousOffset, JdbcConnection jdbcConnection, HistorizedRelationalDatabaseSchema schema, EventDispatcher<TableId> dispatcher, Clock clock, SnapshotProgressListener snapshotProgressListener) {
        this.connectorConfig = connectorConfig;
        this.previousOffset = previousOffset;
        this.jdbcConnection = jdbcConnection;
        this.schema = schema;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.snapshotProgressListener = snapshotProgressListener;
    }

    public RelationalSnapshotChangeEventSource(RelationalDatabaseConnectorConfig connectorConfig, OffsetContext previousOffset, JdbcConnection jdbcConnection, EventDispatcher<TableId> dispatcher, Clock clock, SnapshotProgressListener snapshotProgressListener) {
        this(connectorConfig, previousOffset, jdbcConnection, null, dispatcher, clock, snapshotProgressListener);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SnapshotResult execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        SnapshotResult e2222222;
        SnapshotContext ctx;
        SnapshottingTask snapshottingTask = this.getSnapshottingTask(this.previousOffset);
        if (!snapshottingTask.snapshotSchema() && !snapshottingTask.snapshotData()) {
            LOGGER.debug("Skipping snapshotting");
            return SnapshotResult.skipped(this.previousOffset);
        }
        this.delaySnapshotIfNeeded(context);
        Connection connection = null;
        try {
            ctx = this.prepare(context);
        }
        catch (Exception e2222222) {
            LOGGER.error("Failed to initialize snapshot context.", (Throwable)e2222222);
            throw new RuntimeException(e2222222);
        }
        try {
            LOGGER.info("Snapshot step 1 - Preparing");
            this.snapshotProgressListener.snapshotStarted();
            if (this.previousOffset != null && this.previousOffset.isSnapshotRunning()) {
                LOGGER.info("Previous snapshot was cancelled before completion; a new snapshot will be taken.");
            }
            connection = this.jdbcConnection.connection();
            connection.setAutoCommit(false);
            this.connectionCreated(ctx);
            LOGGER.info("Snapshot step 2 - Determining captured tables");
            this.determineCapturedTables(ctx);
            this.snapshotProgressListener.monitoredTablesDetermined(ctx.capturedTables);
            LOGGER.info("Snapshot step 3 - Locking captured tables");
            if (snapshottingTask.snapshotSchema()) {
                this.lockTablesForSchemaSnapshot(context, ctx);
            }
            LOGGER.info("Snapshot step 4 - Determining snapshot offset");
            this.determineSnapshotOffset(ctx);
            LOGGER.info("Snapshot step 5 - Reading structure of captured tables");
            this.readTableStructure(context, ctx);
            if (snapshottingTask.snapshotSchema()) {
                LOGGER.info("Snapshot step 6 - Persisting schema history");
                this.createSchemaChangeEventsForTables(context, ctx);
                this.releaseSchemaSnapshotLocks(ctx);
            } else {
                LOGGER.info("Snapshot step 6 - Skipping persisting of schema history");
            }
            if (snapshottingTask.snapshotData()) {
                LOGGER.info("Snapshot step 7 - Snapshotting data");
                this.createDataEvents(context, ctx);
            } else {
                LOGGER.info("Snapshot step 7 - Skipping snapshotting of data");
                ctx.offset.preSnapshotCompletion();
                ctx.offset.postSnapshotCompletion();
            }
            this.dispatcher.alwaysDispatchHeartbeatEvent(ctx.offset);
            this.snapshotProgressListener.snapshotCompleted();
            e2222222 = SnapshotResult.completed(ctx.offset);
        }
        catch (InterruptedException e3) {
            try {
                LOGGER.warn("Snapshot was interrupted before completion");
                this.snapshotProgressListener.snapshotAborted();
                throw e3;
                catch (RuntimeException e4) {
                    this.snapshotProgressListener.snapshotAborted();
                    throw e4;
                }
                catch (Throwable e5) {
                    this.snapshotProgressListener.snapshotAborted();
                    throw new RuntimeException(e5);
                }
            }
            catch (Throwable throwable) {
                this.rollbackTransaction(connection);
                LOGGER.info("Snapshot step 8 - Finalizing");
                this.complete(ctx);
                throw throwable;
            }
        }
        this.rollbackTransaction(connection);
        LOGGER.info("Snapshot step 8 - Finalizing");
        this.complete(ctx);
        return e2222222;
    }

    protected abstract SnapshottingTask getSnapshottingTask(OffsetContext var1);

    private void delaySnapshotIfNeeded(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        Duration snapshotDelay = this.connectorConfig.getSnapshotDelay();
        if (snapshotDelay.isZero() || snapshotDelay.isNegative()) {
            return;
        }
        Threads.Timer timer = Threads.timer(Clock.SYSTEM, snapshotDelay);
        Metronome metronome = Metronome.parker(ConfigurationDefaults.RETURN_CONTROL_INTERVAL, Clock.SYSTEM);
        while (!timer.expired()) {
            if (!context.isRunning()) {
                throw new InterruptedException("Interrupted while awaiting initial snapshot delay");
            }
            LOGGER.info("The connector will wait for {}s before proceeding", (Object)timer.remaining().getSeconds());
            metronome.pause();
        }
    }

    protected abstract SnapshotContext prepare(ChangeEventSource.ChangeEventSourceContext var1) throws Exception;

    protected void connectionCreated(SnapshotContext snapshotContext) throws Exception {
    }

    private Stream<TableId> toTableIds(Set<TableId> tableIds, Pattern pattern) {
        return tableIds.stream().filter(tid -> pattern.asPredicate().test(tid.toString())).sorted();
    }

    private Set<TableId> sort(Set<TableId> capturedTables) throws Exception {
        String value = this.connectorConfig.getConfig().getString(RelationalDatabaseConnectorConfig.TABLE_WHITELIST);
        if (value != null) {
            return Strings.listOfRegex(value, 2).stream().flatMap(pattern -> this.toTableIds(capturedTables, (Pattern)pattern)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return capturedTables.stream().sorted().collect(Collectors.toCollection(HashSet::new));
    }

    private void determineCapturedTables(SnapshotContext ctx) throws Exception {
        Set<TableId> allTableIds = this.getAllTableIds(ctx);
        HashSet<TableId> capturedTables = new HashSet<TableId>();
        for (TableId tableId : allTableIds) {
            if (this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
                LOGGER.trace("Adding table {} to the list of captured tables", (Object)tableId);
                capturedTables.add(tableId);
                continue;
            }
            LOGGER.trace("Ignoring table {} as it's not included in the filter configuration", (Object)tableId);
        }
        ctx.capturedTables = this.sort(capturedTables);
    }

    protected abstract Set<TableId> getAllTableIds(SnapshotContext var1) throws Exception;

    protected abstract void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext var1, SnapshotContext var2) throws Exception;

    protected abstract void determineSnapshotOffset(SnapshotContext var1) throws Exception;

    protected abstract void readTableStructure(ChangeEventSource.ChangeEventSourceContext var1, SnapshotContext var2) throws Exception;

    protected abstract void releaseSchemaSnapshotLocks(SnapshotContext var1) throws Exception;

    private void createSchemaChangeEventsForTables(ChangeEventSource.ChangeEventSourceContext sourceContext, SnapshotContext snapshotContext) throws Exception {
        for (TableId tableId : snapshotContext.capturedTables) {
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while capturing schema of table " + tableId);
            }
            LOGGER.debug("Capturing structure of table {}", (Object)tableId);
            Table table = snapshotContext.tables.forTable(tableId);
            if (this.schema == null) continue;
            this.schema.applySchemaChange(this.getCreateTableEvent(snapshotContext, table));
        }
    }

    protected abstract SchemaChangeEvent getCreateTableEvent(SnapshotContext var1, Table var2) throws Exception;

    private void createDataEvents(ChangeEventSource.ChangeEventSourceContext sourceContext, SnapshotContext snapshotContext) throws InterruptedException {
        EventDispatcher.SnapshotReceiver snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
        snapshotContext.offset.preSnapshotStart();
        Iterator<TableId> tableIdIterator = snapshotContext.capturedTables.iterator();
        while (tableIdIterator.hasNext()) {
            TableId tableId = tableIdIterator.next();
            boolean bl = snapshotContext.lastTable = !tableIdIterator.hasNext();
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while snapshotting table " + tableId);
            }
            LOGGER.debug("Snapshotting table {}", (Object)tableId);
            this.createDataEventsForTable(sourceContext, snapshotContext, snapshotReceiver, snapshotContext.tables.forTable(tableId));
        }
        snapshotContext.offset.preSnapshotCompletion();
        snapshotReceiver.completeSnapshot();
        snapshotContext.offset.postSnapshotCompletion();
    }

    private void createDataEventsForTable(ChangeEventSource.ChangeEventSourceContext sourceContext, SnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver snapshotReceiver, Table table) throws InterruptedException {
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.info("\t Exporting data from table '{}'", (Object)table.id());
        Optional<String> selectStatement = this.determineSnapshotSelect(snapshotContext, table.id());
        if (!selectStatement.isPresent()) {
            LOGGER.warn("For table '{}' the select statement was not provided, skipping table", (Object)table.id());
            return;
        }
        LOGGER.info("\t For table '{}' using select statement: '{}'", (Object)table.id(), (Object)selectStatement.get());
        try (Statement statement = this.readTableStatement();
             ResultSet rs = statement.executeQuery(selectStatement.get());){
            Column[] columns = this.getColumnsForResultSet(table, rs);
            int numColumns = table.columns().size();
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            snapshotContext.lastRecordInTable = false;
            if (rs.next()) {
                while (!snapshotContext.lastRecordInTable) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while snapshotting table " + table.id());
                    }
                    ++rows;
                    Object[] row = new Object[numColumns];
                    for (int i = 0; i < numColumns; ++i) {
                        row[i] = this.getColumnValue(rs, i + 1, columns[i]);
                    }
                    boolean bl = snapshotContext.lastRecordInTable = !rs.next();
                    if (logTimer.expired()) {
                        long stop = this.clock.currentTimeInMillis();
                        LOGGER.info("\t Exported {} records for table '{}' after {}", new Object[]{rows, table.id(), Strings.duration(stop - exportStart)});
                        this.snapshotProgressListener.rowsScanned(table.id(), rows);
                        logTimer = this.getTableScanLogTimer();
                    }
                    if (snapshotContext.lastTable && snapshotContext.lastRecordInTable) {
                        snapshotContext.offset.markLastSnapshotRecord();
                    }
                    this.dispatcher.dispatchSnapshotEvent(table.id(), this.getChangeRecordEmitter(snapshotContext, table.id(), row), snapshotReceiver);
                }
            } else if (snapshotContext.lastTable) {
                snapshotContext.offset.markLastSnapshotRecord();
            }
            LOGGER.info("\t Finished exporting {} records for table '{}'; total duration '{}'", new Object[]{rows, table.id(), Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
            this.snapshotProgressListener.tableSnapshotCompleted(table.id(), rows);
        }
        catch (SQLException e) {
            throw new ConnectException("Snapshotting of table " + table.id() + " failed", (Throwable)e);
        }
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer(this.clock, LOG_INTERVAL);
    }

    protected ChangeRecordEmitter getChangeRecordEmitter(SnapshotContext snapshotContext, TableId tableId, Object[] row) {
        snapshotContext.offset.event(tableId, this.getClock().currentTime());
        return new SnapshotChangeRecordEmitter(snapshotContext.offset, row, this.getClock());
    }

    private Optional<String> determineSnapshotSelect(SnapshotContext snapshotContext, TableId tableId) {
        String overriddenSelect = this.connectorConfig.getSnapshotSelectOverridesByTable().get(tableId);
        if (overriddenSelect == null) {
            overriddenSelect = this.connectorConfig.getSnapshotSelectOverridesByTable().get(new TableId(null, tableId.schema(), tableId.table()));
        }
        return overriddenSelect != null ? Optional.of(overriddenSelect) : this.getSnapshotSelect(snapshotContext, tableId);
    }

    protected abstract Optional<String> getSnapshotSelect(SnapshotContext var1, TableId var2);

    private Column[] getColumnsForResultSet(Table table, ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        Column[] columns = new Column[metaData.getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = table.columnWithName(metaData.getColumnName(i + 1));
        }
        return columns;
    }

    protected Object getColumnValue(ResultSet rs, int columnIndex, Column column) throws SQLException {
        return rs.getObject(columnIndex);
    }

    private Statement readTableStatement() throws SQLException {
        int fetchSize = this.connectorConfig.getSnapshotFetchSize();
        Statement statement = this.jdbcConnection.connection().createStatement();
        statement.setFetchSize(fetchSize);
        return statement;
    }

    protected abstract void complete(SnapshotContext var1);

    private void rollbackTransaction(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Clock getClock() {
        return this.clock;
    }

    public static class SnapshottingTask {
        private final boolean snapshotSchema;
        private final boolean snapshotData;

        public SnapshottingTask(boolean snapshotSchema, boolean snapshotData) {
            this.snapshotSchema = snapshotSchema;
            this.snapshotData = snapshotData;
        }

        public boolean snapshotData() {
            return this.snapshotData;
        }

        public boolean snapshotSchema() {
            return this.snapshotSchema;
        }

        public String toString() {
            return "SnapshottingTask [snapshotSchema=" + this.snapshotSchema + ", snapshotData=" + this.snapshotData + "]";
        }
    }

    public static class SnapshotContext
    implements AutoCloseable {
        public final String catalogName;
        public final Tables tables;
        public Set<TableId> capturedTables;
        public OffsetContext offset;
        public boolean lastTable;
        public boolean lastRecordInTable;

        public SnapshotContext(String catalogName) throws SQLException {
            this.catalogName = catalogName;
            this.tables = new Tables();
        }

        @Override
        public void close() throws Exception {
        }
    }
}

