/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import org.apache.cassandra.config.TransparentDataEncryptionOptions;
import org.apache.cassandra.security.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JKSKeyProvider
implements KeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(JKSKeyProvider.class);
    static final String PROP_KEYSTORE = "keystore";
    static final String PROP_KEYSTORE_PW = "keystore_password";
    static final String PROP_KEYSTORE_TYPE = "store_type";
    static final String PROP_KEY_PW = "key_password";
    private final KeyStore store;
    private final boolean isJceks;
    private final TransparentDataEncryptionOptions options;

    public JKSKeyProvider(TransparentDataEncryptionOptions options) {
        this.options = options;
        logger.info("initializing keystore from file {}", (Object)options.get(PROP_KEYSTORE));
        try (FileInputStream inputStream = new FileInputStream(options.get(PROP_KEYSTORE));){
            this.store = KeyStore.getInstance(options.get(PROP_KEYSTORE_TYPE));
            this.store.load(inputStream, options.get(PROP_KEYSTORE_PW).toCharArray());
            this.isJceks = this.store.getType().equalsIgnoreCase("jceks");
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't load keystore", e);
        }
    }

    @Override
    public Key getSecretKey(String keyAlias) throws IOException {
        Key key;
        if (this.isJceks) {
            keyAlias = keyAlias.toLowerCase();
        }
        try {
            String password = this.options.get(PROP_KEY_PW);
            if (password == null || password.isEmpty()) {
                password = this.options.get(PROP_KEYSTORE_PW);
            }
            key = this.store.getKey(keyAlias, password.toCharArray());
        }
        catch (Exception e) {
            throw new IOException("unable to load key from keystore");
        }
        if (key == null) {
            throw new IOException(String.format("key %s was not found in keystore", keyAlias));
        }
        return key;
    }
}

