/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.NodePair;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;

public class SyncComplete
extends RepairMessage {
    public static final RepairMessage.MessageSerializer serializer = new SyncCompleteSerializer();
    public final NodePair nodes;
    public final boolean success;

    public SyncComplete(RepairJobDesc desc, NodePair nodes, boolean success) {
        super(RepairMessage.Type.SYNC_COMPLETE, desc);
        this.nodes = nodes;
        this.success = success;
    }

    public SyncComplete(RepairJobDesc desc, InetAddress endpoint1, InetAddress endpoint2, boolean success) {
        super(RepairMessage.Type.SYNC_COMPLETE, desc);
        this.nodes = new NodePair(endpoint1, endpoint2);
        this.success = success;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyncComplete)) {
            return false;
        }
        SyncComplete other = (SyncComplete)o;
        return this.messageType == other.messageType && this.desc.equals(other.desc) && this.success == other.success && this.nodes.equals(other.nodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageType, this.desc, this.success, this.nodes});
    }

    private static class SyncCompleteSerializer
    implements RepairMessage.MessageSerializer<SyncComplete> {
        private SyncCompleteSerializer() {
        }

        @Override
        public void serialize(SyncComplete message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            NodePair.serializer.serialize(message.nodes, out, version);
            out.writeBoolean(message.success);
        }

        @Override
        public SyncComplete deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = RepairJobDesc.serializer.deserialize(in, version);
            NodePair nodes = NodePair.serializer.deserialize(in, version);
            return new SyncComplete(desc, nodes, in.readBoolean());
        }

        @Override
        public long serializedSize(SyncComplete message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += NodePair.serializer.serializedSize(message.nodes, version);
            return size += (long)TypeSizes.sizeof(message.success);
        }
    }
}

