/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ElectPreferredLeadersRequestData;
import org.apache.kafka.common.message.ElectPreferredLeadersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ElectPreferredLeadersResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class ElectPreferredLeadersRequest
extends AbstractRequest {
    private final ElectPreferredLeadersRequestData data;
    private final short version;

    public static ElectPreferredLeadersRequestData toRequestData(Collection<TopicPartition> partitions, int timeoutMs) {
        ElectPreferredLeadersRequestData d = new ElectPreferredLeadersRequestData().setTimeoutMs(timeoutMs);
        if (partitions != null) {
            for (Map.Entry<String, List<Integer>> tp : CollectionUtils.groupPartitionsByTopic(partitions).entrySet()) {
                d.topicPartitions().add(new ElectPreferredLeadersRequestData.TopicPartitions().setTopic(tp.getKey()).setPartitionId(tp.getValue()));
            }
        } else {
            d.setTopicPartitions(null);
        }
        return d;
    }

    public static Map<TopicPartition, ApiError> fromResponseData(ElectPreferredLeadersResponseData data) {
        HashMap<TopicPartition, ApiError> map = new HashMap<TopicPartition, ApiError>();
        for (ElectPreferredLeadersResponseData.ReplicaElectionResult topicResults : data.replicaElectionResults()) {
            for (ElectPreferredLeadersResponseData.PartitionResult partitionResult : topicResults.partitionResult()) {
                map.put(new TopicPartition(topicResults.topic(), partitionResult.partitionId()), new ApiError(Errors.forCode(partitionResult.errorCode()), partitionResult.errorMessage()));
            }
        }
        return map;
    }

    private ElectPreferredLeadersRequest(ElectPreferredLeadersRequestData data, short version) {
        super(ApiKeys.ELECT_PREFERRED_LEADERS, version);
        this.data = data;
        this.version = version;
    }

    public ElectPreferredLeadersRequest(Struct struct, short version) {
        super(ApiKeys.ELECT_PREFERRED_LEADERS, version);
        this.data = new ElectPreferredLeadersRequestData(struct, version);
        this.version = version;
    }

    public ElectPreferredLeadersRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ElectPreferredLeadersResponseData response = new ElectPreferredLeadersResponseData();
        response.setThrottleTimeMs(throttleTimeMs);
        ApiError apiError = ApiError.fromThrowable(e);
        for (ElectPreferredLeadersRequestData.TopicPartitions topic : this.data.topicPartitions()) {
            ElectPreferredLeadersResponseData.ReplicaElectionResult electionResult = new ElectPreferredLeadersResponseData.ReplicaElectionResult().setTopic(topic.topic());
            for (Integer partitionId : topic.partitionId()) {
                electionResult.partitionResult().add(new ElectPreferredLeadersResponseData.PartitionResult().setPartitionId(partitionId).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
            }
            response.replicaElectionResults().add(electionResult);
        }
        return new ElectPreferredLeadersResponse(response);
    }

    public static ElectPreferredLeadersRequest parse(ByteBuffer buffer, short version) {
        return new ElectPreferredLeadersRequest(ApiKeys.ELECT_PREFERRED_LEADERS.parseRequest(version, buffer), version);
    }

    @Override
    public Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ElectPreferredLeadersRequest> {
        private final ElectPreferredLeadersRequestData data;

        public Builder(ElectPreferredLeadersRequestData data) {
            super(ApiKeys.ELECT_PREFERRED_LEADERS);
            this.data = data;
        }

        @Override
        public ElectPreferredLeadersRequest build(short version) {
            return new ElectPreferredLeadersRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

