/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.ChangeRecord;
import io.debezium.connector.cassandra.FieldFilterSelector;
import io.debezium.connector.cassandra.Filters;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.RowData;
import io.debezium.connector.cassandra.SourceInfo;
import io.debezium.connector.cassandra.TombstoneRecord;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Schema;

public class RecordMaker {
    private final boolean emitTombstoneOnDelete;
    private final Filters filters;

    public RecordMaker(boolean emitTombstoneOnDelete, Filters filters) {
        this.emitTombstoneOnDelete = emitTombstoneOnDelete;
        this.filters = filters;
    }

    public void insert(SourceInfo source, RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, Consumer<Record> consumer) {
        this.createRecord(source, data, keySchema, valueSchema, markOffset, consumer, Record.Operation.INSERT);
    }

    public void update(SourceInfo source, RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, Consumer<Record> consumer) {
        this.createRecord(source, data, keySchema, valueSchema, markOffset, consumer, Record.Operation.UPDATE);
    }

    public void delete(SourceInfo source, RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, Consumer<Record> consumer) {
        this.createRecord(source, data, keySchema, valueSchema, markOffset, consumer, Record.Operation.DELETE);
    }

    private void createRecord(SourceInfo source, RowData data, Schema keySchema, Schema valueSchema, boolean markOffset, Consumer<Record> consumer, Record.Operation operation) {
        RowData filteredData;
        FieldFilterSelector.FieldFilter fieldFilter = this.filters.getFieldFilter(source.keyspaceTable);
        switch (operation) {
            case INSERT: 
            case UPDATE: {
                filteredData = fieldFilter.apply(data);
                break;
            }
            default: {
                filteredData = data;
            }
        }
        ChangeRecord record = new ChangeRecord(source, filteredData, keySchema, valueSchema, operation, markOffset);
        consumer.accept(record);
        if (operation == Record.Operation.DELETE && this.emitTombstoneOnDelete) {
            TombstoneRecord tombstoneRecord = new TombstoneRecord(source, filteredData, keySchema);
            consumer.accept(tombstoneRecord);
        }
    }
}

