/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.exceptions.CassandraConnectorDataException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommitLogUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogUtil.class);
    private static final Pattern FILENAME_REGEX_PATTERN = Pattern.compile("CommitLog-\\d+-(\\d+).log");

    private CommitLogUtil() {
    }

    public static void moveCommitLog(File file, Path toDir) {
        try {
            Matcher filenameMatcher = FILENAME_REGEX_PATTERN.matcher(file.getName());
            if (!filenameMatcher.matches()) {
                throw new IllegalArgumentException("Cannot move file because " + file.getName() + " does not appear to be a CommitLog");
            }
            Files.move(file.toPath(), toDir.resolve(file.getName()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            LOGGER.error("Failed to move the file {} from {}", new Object[]{file.getName(), toDir.getFileName(), e});
        }
    }

    public static void deleteCommitLog(File file) {
        try {
            Matcher filenameMatcher = FILENAME_REGEX_PATTERN.matcher(file.getName());
            if (!filenameMatcher.matches()) {
                throw new IllegalArgumentException("Cannot delete file beca use " + file.getName() + " does not appear to be a CommitLog");
            }
            Files.delete(file.toPath());
            LOGGER.debug("Deleted commit log {} in cdc directory", (Object)file.getName());
        }
        catch (Exception e) {
            LOGGER.error("Failed to delete the file {} from cdc directory: ", (Object)file.getName(), (Object)e);
        }
    }

    public static File[] getCommitLogs(File directory) {
        return directory.listFiles(f -> f.isFile() && FILENAME_REGEX_PATTERN.matcher(f.getName()).matches());
    }

    public static int compareCommitLogs(File file1, File file2) {
        if (file1.equals(file2)) {
            return 0;
        }
        long ts1 = CommitLogUtil.extractTimestamp(file1.getName());
        long ts2 = CommitLogUtil.extractTimestamp(file2.getName());
        return Long.compare(ts1, ts2);
    }

    public static int compareCommitLogs(String filename1, String filename2) {
        if (filename1.equals(filename2)) {
            return 0;
        }
        long ts1 = CommitLogUtil.extractTimestamp(filename1);
        long ts2 = CommitLogUtil.extractTimestamp(filename2);
        return Long.compare(ts1, ts2);
    }

    private static long extractTimestamp(String commitLogFileName) {
        Matcher filenameMatcher = FILENAME_REGEX_PATTERN.matcher(commitLogFileName);
        if (!filenameMatcher.matches()) {
            throw new CassandraConnectorDataException("Cannot extract timestamp because " + commitLogFileName + " does not appear to be a CommitLog");
        }
        return Long.parseLong(filenameMatcher.group(1));
    }
}

