/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerDe;
import io.confluent.kafka.serializers.AvroSchemaUtils;
import io.confluent.kafka.serializers.GenericContainerWithVersion;
import io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kafka.utils.VerifiableProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaAvroDeserializer
extends AbstractKafkaAvroSerDe {
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    protected boolean useSpecificAvroReader = false;
    private final Map<String, Schema> readerSchemaCache = new ConcurrentHashMap<String, Schema>();

    protected void configure(KafkaAvroDeserializerConfig config) {
        this.configureClientProperties(config);
        this.useSpecificAvroReader = config.getBoolean("specific.avro.reader");
    }

    protected KafkaAvroDeserializerConfig deserializerConfig(Map<String, ?> props) {
        try {
            return new KafkaAvroDeserializerConfig(props);
        }
        catch (io.confluent.common.config.ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected KafkaAvroDeserializerConfig deserializerConfig(VerifiableProperties props) {
        try {
            return new KafkaAvroDeserializerConfig(props.props());
        }
        catch (io.confluent.common.config.ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    private ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer;
    }

    protected Object deserialize(byte[] payload) throws SerializationException {
        return this.deserialize(false, null, null, payload, null);
    }

    protected Object deserialize(byte[] payload, Schema readerSchema) throws SerializationException {
        return this.deserialize(false, null, null, payload, readerSchema);
    }

    protected Object deserialize(boolean includeSchemaAndVersion, String topic, Boolean isKey, byte[] payload, Schema readerSchema) throws SerializationException {
        if (payload == null) {
            return null;
        }
        int id = -1;
        try {
            Object result;
            ByteBuffer buffer = this.getByteBuffer(payload);
            id = buffer.getInt();
            Schema schema = this.schemaRegistry.getById(id);
            String subject = null;
            if (includeSchemaAndVersion) {
                subject = this.subjectName(topic, isKey, schema);
                schema = this.schemaForDeserialize(id, schema, subject, isKey);
            }
            int length = buffer.limit() - 1 - 4;
            if (schema.getType().equals((Object)Schema.Type.BYTES)) {
                byte[] bytes = new byte[length];
                buffer.get(bytes, 0, length);
                result = bytes;
            } else {
                int start = buffer.position() + buffer.arrayOffset();
                DatumReader reader = this.getDatumReader(schema, readerSchema);
                Object object = reader.read(null, (Decoder)this.decoderFactory.binaryDecoder(buffer.array(), start, length, null));
                if (schema.getType().equals((Object)Schema.Type.STRING)) {
                    object = object.toString();
                }
                result = object;
            }
            if (includeSchemaAndVersion) {
                Integer version = this.schemaVersion(topic, isKey, id, subject, schema, result);
                if (schema.getType().equals((Object)Schema.Type.RECORD)) {
                    return new GenericContainerWithVersion((GenericContainer)result, version);
                }
                return new GenericContainerWithVersion(new NonRecordContainer(schema, result), version);
            }
            return result;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error deserializing Avro message for id " + id, (Throwable)e);
        }
        catch (RestClientException e) {
            throw new SerializationException("Error retrieving Avro schema for id " + id, (Throwable)e);
        }
    }

    private Integer schemaVersion(String topic, Boolean isKey, int id, String subject, Schema schema, Object result) throws IOException, RestClientException {
        Integer version;
        if (this.isDeprecatedSubjectNameStrategy(isKey)) {
            subject = this.getSubjectName(topic, isKey, result, schema);
            Schema subjectSchema = this.schemaRegistry.getBySubjectAndId(subject, id);
            version = this.schemaRegistry.getVersion(subject, subjectSchema);
        } else {
            version = this.schemaRegistry.getVersion(subject, schema);
        }
        return version;
    }

    private String subjectName(String topic, Boolean isKey, Schema schemaFromRegistry) {
        return this.isDeprecatedSubjectNameStrategy(isKey) ? null : this.getSubjectName(topic, isKey, null, schemaFromRegistry);
    }

    private Schema schemaForDeserialize(int id, Schema schemaFromRegistry, String subject, Boolean isKey) throws IOException, RestClientException {
        return this.isDeprecatedSubjectNameStrategy(isKey) ? AvroSchemaUtils.copyOf(schemaFromRegistry) : this.schemaRegistry.getBySubjectAndId(subject, id);
    }

    protected GenericContainerWithVersion deserializeWithSchemaAndVersion(String topic, boolean isKey, byte[] payload) throws SerializationException {
        return (GenericContainerWithVersion)this.deserialize(true, topic, isKey, payload, null);
    }

    private DatumReader getDatumReader(Schema writerSchema, Schema readerSchema) {
        boolean writerSchemaIsPrimitive = AvroSchemaUtils.getPrimitiveSchemas().values().contains(writerSchema);
        if (this.useSpecificAvroReader && !writerSchemaIsPrimitive) {
            if (readerSchema == null) {
                readerSchema = this.getReaderSchema(writerSchema);
            }
            return new SpecificDatumReader(writerSchema, readerSchema);
        }
        if (readerSchema == null) {
            return new GenericDatumReader(writerSchema);
        }
        return new GenericDatumReader(writerSchema, readerSchema);
    }

    private Schema getReaderSchema(Schema writerSchema) {
        Schema readerSchema = this.readerSchemaCache.get(writerSchema.getFullName());
        if (readerSchema == null) {
            Class readerClass = SpecificData.get().getClass(writerSchema);
            if (readerClass != null) {
                try {
                    readerSchema = ((SpecificRecord)readerClass.newInstance()).getSchema();
                }
                catch (InstantiationException e) {
                    throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema could not be instantiated to find the readers schema.");
                }
                catch (IllegalAccessException e) {
                    throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema is not allowed to be instantiated to find the readers schema.");
                }
                this.readerSchemaCache.put(writerSchema.getFullName(), readerSchema);
            } else {
                throw new SerializationException("Could not find class " + writerSchema.getFullName() + " specified in writer's schema whilst finding reader's schema for a SpecificRecord.");
            }
        }
        return readerSchema;
    }
}

