/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.CassandraTypeKafkaSchemaBuilders;
import io.debezium.connector.cassandra.transforms.UuidUtil;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Values;
import org.junit.Assert;
import org.junit.Test;

public class CassandraTypeDeserializerTest {
    private static final Charset CHARSET = Charset.forName("UTF-8");

    @Test
    public void testAscii() {
        String expectedAscii = "some text";
        ByteBuffer serializedAscii = AsciiType.instance.decompose((Object)expectedAscii);
        Object deserializedAscii = CassandraTypeDeserializer.deserialize((AbstractType)AsciiType.instance, (ByteBuffer)serializedAscii);
        Assert.assertEquals((Object)"some text", (Object)deserializedAscii);
    }

    @Test
    public void testBoolean() {
        Boolean expectedBoolean = true;
        ByteBuffer serializedBoolean = BooleanType.instance.decompose((Object)expectedBoolean);
        Object deserializedBoolean = CassandraTypeDeserializer.deserialize((AbstractType)BooleanType.instance, (ByteBuffer)serializedBoolean);
        Assert.assertEquals((Object)expectedBoolean, (Object)deserializedBoolean);
    }

    @Test
    public void testBytes() {
        ByteBuffer expectedBytes = ByteBuffer.wrap("some random stuff here".getBytes(CHARSET));
        ByteBuffer serializedBytes = BytesType.instance.decompose((Object)expectedBytes);
        Object deserializedBytes = CassandraTypeDeserializer.deserialize((AbstractType)BytesType.instance, (ByteBuffer)serializedBytes);
        Assert.assertEquals((Object)expectedBytes, (Object)deserializedBytes);
    }

    @Test
    public void testByteType() {
        Byte expectedByte = Byte.valueOf("9");
        ByteBuffer serializedByte = ByteType.instance.decompose((Object)expectedByte);
        Object deserializedByte = CassandraTypeDeserializer.deserialize((AbstractType)ByteType.instance, (ByteBuffer)serializedByte);
        Assert.assertEquals((Object)expectedByte, (Object)deserializedByte);
    }

    @Test
    public void testCounterColumnType() {
        Long expectedCounterColumnType = 42L;
        ByteBuffer serializedCounter = CounterColumnType.instance.decompose(Long.valueOf(42L));
        Object deserializedCounter = CassandraTypeDeserializer.deserialize((AbstractType)CounterColumnType.instance, (ByteBuffer)serializedCounter);
        Assert.assertEquals((Object)expectedCounterColumnType, (Object)deserializedCounter);
    }

    @Test
    public void testDecimalType() {
        BigDecimal expectedDecimal = BigDecimal.valueOf(Math.PI);
        ByteBuffer serializedDecimal = DecimalType.instance.decompose((Object)expectedDecimal);
        Object deserializedDecimal = CassandraTypeDeserializer.deserialize((AbstractType)DecimalType.instance, (ByteBuffer)serializedDecimal);
        Assert.assertEquals((Object)expectedDecimal, (Object)deserializedDecimal);
    }

    @Test
    public void testDoubleType() {
        Double expectedDouble = 100.5;
        ByteBuffer serializedDouble = DoubleType.instance.decompose((Object)expectedDouble);
        Object deserializedDouble = CassandraTypeDeserializer.deserialize((AbstractType)DoubleType.instance, (ByteBuffer)serializedDouble);
        Assert.assertEquals((Object)expectedDouble, (Object)deserializedDouble);
    }

    @Test
    public void testDurationType() {
        Duration sourceDuration = Duration.newInstance((int)1, (int)3, (long)500L);
        long expectedNanoDuration = 33L * ChronoUnit.DAYS.getDuration().toNanos() + 500L;
        ByteBuffer serializedDuration = DurationType.instance.decompose((Object)sourceDuration);
        Object deserializedDuration = CassandraTypeDeserializer.deserialize((AbstractType)DurationType.instance, (ByteBuffer)serializedDuration);
        Assert.assertEquals((Object)expectedNanoDuration, (Object)deserializedDuration);
    }

    @Test
    public void testFloatType() {
        Float expectedFloat = Float.valueOf(66.6f);
        ByteBuffer serializedFloat = FloatType.instance.decompose((Object)expectedFloat);
        Object deserializedFloat = CassandraTypeDeserializer.deserialize((AbstractType)FloatType.instance, (ByteBuffer)serializedFloat);
        Assert.assertEquals((Object)expectedFloat, (Object)deserializedFloat);
    }

    @Test
    public void testInetAddressType() throws UnknownHostException {
        InetAddress sourceInetAddress = InetAddress.getLocalHost();
        String expectedInetAddress = "/" + sourceInetAddress.getHostAddress();
        ByteBuffer serializedInetAddress = InetAddressType.instance.decompose((Object)sourceInetAddress);
        Object deserializedInetAddress = CassandraTypeDeserializer.deserialize((AbstractType)InetAddressType.instance, (ByteBuffer)serializedInetAddress);
        Assert.assertEquals((Object)expectedInetAddress, (Object)deserializedInetAddress);
    }

    @Test
    public void testInt32Type() {
        Integer expectedInteger = 8;
        ByteBuffer serializedInt32 = Int32Type.instance.decompose((Object)expectedInteger);
        Object deserializedInt32 = CassandraTypeDeserializer.deserialize((AbstractType)Int32Type.instance, (ByteBuffer)serializedInt32);
        Assert.assertEquals((Object)expectedInteger, (Object)deserializedInt32);
    }

    @Test
    public void testListType() {
        ArrayList<Integer> expectedList = new ArrayList<Integer>();
        expectedList.add(1);
        expectedList.add(3);
        expectedList.add(5);
        ListType nonFrozenListType = ListType.getInstance((AbstractType)Int32Type.instance, (boolean)true);
        ByteBuffer serializedList = nonFrozenListType.decompose(expectedList);
        Object deserializedList = CassandraTypeDeserializer.deserialize((AbstractType)nonFrozenListType, (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
        ListType frozenListType = ListType.getInstance((AbstractType)Int32Type.instance, (boolean)false);
        serializedList = frozenListType.decompose(expectedList);
        deserializedList = CassandraTypeDeserializer.deserialize((AbstractType)frozenListType, (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
    }

    @Test
    public void testLongType() {
        Long expectedLong = 8L;
        ByteBuffer serializedLong = LongType.instance.decompose((Object)expectedLong);
        Object deserializedLong = CassandraTypeDeserializer.deserialize((AbstractType)LongType.instance, (ByteBuffer)serializedLong);
        Assert.assertEquals((Object)expectedLong, (Object)deserializedLong);
    }

    @Test
    public void testMapType() {
        HashMap<String, Double> expectedMap = new HashMap<String, Double>();
        expectedMap.put("foo", 1.0);
        expectedMap.put("bar", 50.0);
        MapType nonFrozenMapType = MapType.getInstance((AbstractType)AsciiType.instance, (AbstractType)DoubleType.instance, (boolean)true);
        ByteBuffer serializedMap = nonFrozenMapType.decompose(expectedMap);
        Object deserializedMap = CassandraTypeDeserializer.deserialize((AbstractType)nonFrozenMapType, (ByteBuffer)serializedMap);
        Assert.assertEquals(expectedMap, (Object)deserializedMap);
        MapType frozenMapType = MapType.getInstance((AbstractType)AsciiType.instance, (AbstractType)DoubleType.instance, (boolean)false);
        serializedMap = frozenMapType.decompose(expectedMap);
        deserializedMap = CassandraTypeDeserializer.deserialize((AbstractType)frozenMapType, (ByteBuffer)serializedMap);
        Assert.assertEquals(expectedMap, (Object)deserializedMap);
    }

    @Test
    public void testMapTypeNonStringKeys() {
        HashMap<Integer, Float> sourceMap = new HashMap<Integer, Float>();
        sourceMap.put(1, Float.valueOf(1.5f));
        sourceMap.put(2, Float.valueOf(3.1414f));
        MapType mapType = MapType.getInstance((AbstractType)Int32Type.instance, (AbstractType)FloatType.instance, (boolean)true);
        ByteBuffer serializedMap = mapType.decompose(sourceMap);
        Object deserializedMap = CassandraTypeDeserializer.deserialize((AbstractType)mapType, (ByteBuffer)serializedMap);
        HashMap<Integer, Float> expectedMap = new HashMap<Integer, Float>();
        expectedMap.put(1, Float.valueOf(1.5f));
        expectedMap.put(2, Float.valueOf(3.1414f));
        Assert.assertEquals(expectedMap, (Object)deserializedMap);
    }

    @Test
    public void testSetType() {
        HashSet<Float> sourceSet = new HashSet<Float>();
        sourceSet.add(Float.valueOf(42.0f));
        sourceSet.add(Float.valueOf(123.0f));
        SetType nonFrozenSetType = SetType.getInstance((AbstractType)FloatType.instance, (boolean)true);
        ByteBuffer serializedSet = nonFrozenSetType.decompose(sourceSet);
        Collection deserializedSet = (Collection)CassandraTypeDeserializer.deserialize((AbstractType)nonFrozenSetType, (ByteBuffer)serializedSet);
        Assert.assertTrue((boolean)sourceSet.containsAll(deserializedSet));
        Assert.assertTrue((boolean)deserializedSet.containsAll(sourceSet));
        SetType frozenSetType = SetType.getInstance((AbstractType)FloatType.instance, (boolean)false);
        serializedSet = frozenSetType.decompose(sourceSet);
        deserializedSet = (Collection)CassandraTypeDeserializer.deserialize((AbstractType)frozenSetType, (ByteBuffer)serializedSet);
        Assert.assertTrue((boolean)sourceSet.containsAll(deserializedSet));
        Assert.assertTrue((boolean)deserializedSet.containsAll(sourceSet));
    }

    @Test
    public void testShortType() {
        Short expectedShort = 2;
        ByteBuffer serializedShort = ShortType.instance.decompose((Object)expectedShort);
        Object deserializedShort = CassandraTypeDeserializer.deserialize((AbstractType)ShortType.instance, (ByteBuffer)serializedShort);
        Assert.assertEquals((Object)expectedShort, (Object)deserializedShort);
    }

    @Test
    public void testSimpleDateType() {
        Integer expectedDate = 17953;
        ByteBuffer serializedDate = SimpleDateType.instance.decompose((Object)expectedDate);
        Object deserializedShort = CassandraTypeDeserializer.deserialize((AbstractType)SimpleDateType.instance, (ByteBuffer)serializedDate);
        Assert.assertEquals((Object)expectedDate, (Object)deserializedShort);
    }

    @Test
    public void testTimeType() {
        Long expectedTime = 30L;
        ByteBuffer serializedTime = TimeType.instance.decompose((Object)expectedTime);
        Object deserializedTime = CassandraTypeDeserializer.deserialize((AbstractType)TimeType.instance, (ByteBuffer)serializedTime);
        Assert.assertEquals((Object)expectedTime, (Object)deserializedTime);
    }

    @Test
    public void testTimestampType() {
        Date timestamp = new Date();
        Long expectedLongTimestamp = timestamp.getTime();
        ByteBuffer serializedTimestamp = TimestampType.instance.decompose((Object)timestamp);
        Object deserializedTimestamp = CassandraTypeDeserializer.deserialize((AbstractType)TimestampType.instance, (ByteBuffer)serializedTimestamp);
        Assert.assertEquals((Object)expectedLongTimestamp, (Object)deserializedTimestamp);
    }

    @Test
    public void testTimeUUIDType() {
        UUID timeUUID = UUID.randomUUID();
        String expectedFixedUUID = Values.convertToString((Schema)CassandraTypeKafkaSchemaBuilders.UUID_TYPE, (Object)UuidUtil.asBytes((UUID)timeUUID));
        ByteBuffer serializedTimeUUID = TimeUUIDType.instance.decompose((Object)timeUUID);
        Object deserializedTimeUUID = CassandraTypeDeserializer.deserialize((AbstractType)TimeUUIDType.instance, (ByteBuffer)serializedTimeUUID);
        Assert.assertEquals((Object)expectedFixedUUID, (Object)deserializedTimeUUID);
    }

    @Test
    public void testTupleType() {
        ArrayList<Object> innerAbstractTypes = new ArrayList<Object>(2);
        innerAbstractTypes.add(AsciiType.instance);
        innerAbstractTypes.add(ShortType.instance);
        TupleType tupleType = new TupleType(innerAbstractTypes);
        String sourceTupleString = "foo:1";
        ByteBuffer serializedTuple = tupleType.fromString(sourceTupleString);
        Object deserializedTuple = CassandraTypeDeserializer.deserialize((AbstractType)tupleType, (ByteBuffer)serializedTuple);
        Schema tupleSchema = CassandraTypeDeserializer.getSchemaBuilder((AbstractType)tupleType).build();
        Struct expectedTuple = new Struct(tupleSchema).put("field1", (Object)"foo").put("field2", (Object)1);
        Assert.assertEquals((Object)expectedTuple, (Object)deserializedTuple);
    }

    @Test
    public void testUserType() {
        ByteBuffer expectedTypeName = ByteBuffer.wrap("FooType".getBytes(Charset.defaultCharset()));
        ArrayList<FieldIdentifier> expectedFieldIdentifiers = new ArrayList<FieldIdentifier>();
        expectedFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("asciiField".getBytes(Charset.defaultCharset()))));
        expectedFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("doubleField".getBytes(Charset.defaultCharset()))));
        expectedFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("durationField".getBytes(Charset.defaultCharset()))));
        ArrayList<Object> expectedFieldTypes = new ArrayList<Object>();
        expectedFieldTypes.add(AsciiType.instance);
        expectedFieldTypes.add(DoubleType.instance);
        expectedFieldTypes.add(DurationType.instance);
        UserType userType = new UserType("barspace", expectedTypeName, expectedFieldIdentifiers, expectedFieldTypes, true);
        Schema userSchema = CassandraTypeDeserializer.getSchemaBuilder((AbstractType)userType).build();
        long expectedNanoDuration = 32L * ChronoUnit.DAYS.getDuration().toNanos() + 3L;
        Struct expectedUserTypeData = new Struct(userSchema).put("asciiField", (Object)"foobar").put("doubleField", (Object)1.5).put("durationField", (Object)expectedNanoDuration);
        HashMap<String, Object> jsonObject = new HashMap<String, Object>(3);
        jsonObject.put("\"asciiField\"", "foobar");
        jsonObject.put("\"doubleField\"", 1.5);
        jsonObject.put("\"durationField\"", DurationType.instance.getSerializer().toString((Object)Duration.newInstance((int)1, (int)2, (long)3L)));
        Term userTypeObject = userType.fromJSONObject(jsonObject);
        ByteBuffer buffer = userTypeObject.bindAndGet(QueryOptions.DEFAULT);
        ByteBuffer serializedUserTypeObject = userType.decompose((Object)buffer);
        Object deserializedUserTypeObject = CassandraTypeDeserializer.deserialize((AbstractType)userType, (ByteBuffer)serializedUserTypeObject);
        Assert.assertEquals((Object)expectedUserTypeData, (Object)deserializedUserTypeObject);
    }

    @Test
    public void testUTF8Type() {
        String expectedUTF8 = "Fourscore and seven years ago";
        ByteBuffer serializedUTF8 = UTF8Type.instance.decompose((Object)expectedUTF8);
        Object deserializedUTF8 = CassandraTypeDeserializer.deserialize((AbstractType)UTF8Type.instance, (ByteBuffer)serializedUTF8);
        Assert.assertEquals((Object)expectedUTF8, (Object)deserializedUTF8);
    }

    @Test
    public void testUUIDType() {
        UUID uuid = UUID.randomUUID();
        String expectedFixedUUID = Values.convertToString((Schema)CassandraTypeKafkaSchemaBuilders.UUID_TYPE, (Object)UuidUtil.asBytes((UUID)uuid));
        ByteBuffer serializedUUID = UUIDType.instance.decompose((Object)uuid);
        Object deserializedUUID = CassandraTypeDeserializer.deserialize((AbstractType)UUIDType.instance, (ByteBuffer)serializedUUID);
        Assert.assertEquals((Object)expectedFixedUUID, (Object)deserializedUUID);
    }
}

