/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DeleteTopicsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private DeletableTopicResultCollection responses;
    public static final Schema SCHEMA_0 = new Schema(new Field("responses", new ArrayOf(DeletableTopicResult.SCHEMA_0), "The results for each topic we tried to delete."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public DeleteTopicsResponseData(Readable readable, short version) {
        this.responses = new DeletableTopicResultCollection(0);
        this.read(readable, version);
    }

    public DeleteTopicsResponseData(Struct struct, short version) {
        this.responses = new DeletableTopicResultCollection(0);
        this.fromStruct(struct, version);
    }

    public DeleteTopicsResponseData() {
        this.throttleTimeMs = 0;
        this.responses = new DeletableTopicResultCollection(0);
    }

    @Override
    public short apiKey() {
        return 20;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 1 ? readable.readInt() : 0;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.responses = null;
        } else {
            this.responses.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.responses.add(new DeletableTopicResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 1) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeInt(this.responses.size());
        for (DeletableTopicResult element : this.responses) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        Object[] nestedObjects = struct.getArray("responses");
        this.responses = new DeletableTopicResultCollection(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.responses.add(new DeletableTopicResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] nestedObjects = new Struct[this.responses.size()];
        int i = 0;
        for (DeletableTopicResult element : this.responses) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("responses", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (version >= 1) {
            size += 4;
        } else if (this.throttleTimeMs != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default throttleTimeMs at version " + version);
        }
        size += 4;
        for (DeletableTopicResult element : this.responses) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteTopicsResponseData)) {
            return false;
        }
        DeleteTopicsResponseData other = (DeleteTopicsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.responses == null ? other.responses != null : !this.responses.equals(other.responses));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.responses == null ? 0 : this.responses.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DeleteTopicsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", responses=" + MessageUtil.deepToString(this.responses.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public DeletableTopicResultCollection responses() {
        return this.responses;
    }

    public DeleteTopicsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteTopicsResponseData setResponses(DeletableTopicResultCollection v) {
        this.responses = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", new ArrayOf(DeletableTopicResult.SCHEMA_0), "The results for each topic we tried to delete.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class DeletableTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<DeletableTopicResult> {
        public DeletableTopicResultCollection() {
        }

        public DeletableTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DeletableTopicResultCollection(Iterator<DeletableTopicResult> iterator) {
            super(iterator);
        }

        @Override
        public DeletableTopicResult find(String name) {
            DeletableTopicResult key = new DeletableTopicResult();
            key.setName(name);
            return this.find(key);
        }

        @Override
        public List<DeletableTopicResult> findAll(String name) {
            DeletableTopicResult key = new DeletableTopicResult();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class DeletableTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private short errorCode;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public DeletableTopicResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public DeletableTopicResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public DeletableTopicResult() {
            this.name = "";
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            this.errorCode = readable.readShort();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeShort(this.errorCode);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            this.errorCode = struct.getShort("error_code");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeletableTopicResult)) {
                return false;
            }
            DeletableTopicResult other = (DeletableTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DeletableTopicResult(name='" + this.name + "', errorCode=" + this.errorCode + ")";
        }

        public String name() {
            return this.name;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public DeletableTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public DeletableTopicResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("error_code", Type.INT16, "The deletion error, or 0 if the deletion succeeded."))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

