/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.AbstractDirectoryWatcher;
import io.debezium.connector.cassandra.AbstractProcessor;
import io.debezium.connector.cassandra.BlockingEventQueue;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.CommitLogProcessorMetrics;
import io.debezium.connector.cassandra.CommitLogReadHandlerImpl;
import io.debezium.connector.cassandra.CommitLogUtil;
import io.debezium.connector.cassandra.EOFEvent;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.Filters;
import io.debezium.connector.cassandra.RecordMaker;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Arrays;
import java.util.Collections;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLogReadHandler;
import org.apache.cassandra.db.commitlog.CommitLogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitLogProcessor
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogProcessor.class);
    private static final String NAME = "Commit Log Processor";
    private final CommitLogReader commitLogReader;
    private final CommitLogReadHandlerImpl commitLogReadHandler;
    private final File cdcDir;
    private final AbstractDirectoryWatcher watcher;
    private final BlockingEventQueue<Event> queue;
    private final boolean latestOnly;
    private final CommitLogProcessorMetrics metrics = new CommitLogProcessorMetrics();
    private boolean initial = true;

    public CommitLogProcessor(CassandraConnectorContext context) throws IOException {
        super(NAME, 0L);
        this.commitLogReader = new CommitLogReader();
        this.queue = context.getQueue();
        this.commitLogReadHandler = new CommitLogReadHandlerImpl(context.getSchemaHolder(), context.getQueue(), context.getOffsetWriter(), new RecordMaker(context.getCassandraConnectorConfig().tombstonesOnDelete(), new Filters(context.getCassandraConnectorConfig().fieldBlacklist())), this.metrics);
        this.cdcDir = new File(DatabaseDescriptor.getCDCLogLocation());
        this.watcher = new AbstractDirectoryWatcher(this.cdcDir.toPath(), context.getCassandraConnectorConfig().cdcDirPollIntervalMs(), Collections.singleton(StandardWatchEventKinds.ENTRY_CREATE)){

            void handleEvent(WatchEvent event, Path path) throws IOException {
                if (CommitLogProcessor.this.isRunning()) {
                    CommitLogProcessor.this.processCommitLog(path.toFile());
                }
            }
        };
        this.latestOnly = context.getCassandraConnectorConfig().latestCommitLogOnly();
    }

    @Override
    public void initialize() {
        this.metrics.registerMetrics();
    }

    @Override
    public void destroy() {
        this.metrics.unregisterMetrics();
    }

    @Override
    public void process() throws IOException, InterruptedException {
        if (this.latestOnly) {
            this.processLastModifiedCommitLog();
            throw new InterruptedException();
        }
        if (this.initial) {
            LOGGER.info("Reading existing commit logs in {}", (Object)this.cdcDir);
            File[] commitLogFiles = CommitLogUtil.getCommitLogs(this.cdcDir);
            Arrays.sort(commitLogFiles, CommitLogUtil::compareCommitLogs);
            for (File commitLogFile : commitLogFiles) {
                if (!this.isRunning()) continue;
                this.processCommitLog(commitLogFile);
            }
            this.initial = false;
        }
        this.watcher.poll();
    }

    void processCommitLog(File file) throws IOException {
        if (file == null) {
            throw new IOException("Commit log is null");
        }
        if (!file.exists()) {
            throw new IOException("Commit log " + file.getName() + " does not exist");
        }
        try {
            LOGGER.info("Processing commit log {}", (Object)file.getName());
            this.metrics.setCommitLogFilename(file.getName());
            this.commitLogReader.readCommitLogSegment((CommitLogReadHandler)this.commitLogReadHandler, file, false);
            this.queue.enqueue(new EOFEvent(file, true));
            LOGGER.info("Successfully processed commit log {}", (Object)file.getName());
        }
        catch (IOException e) {
            this.queue.enqueue(new EOFEvent(file, false));
            LOGGER.warn("Error occurred while processing commit log " + file.getName(), (Throwable)e);
        }
    }

    void processLastModifiedCommitLog() throws IOException {
        LOGGER.warn("CommitLogProcessor will read the last modified commit log from the COMMIT LOG DIRECTORY based on modified timestamp, NOT FROM THE CDC_RAW DIRECTORY. This method should not be used in PRODUCTION!");
        File commitLogDir = new File(DatabaseDescriptor.getCommitLogLocation());
        File[] files = CommitLogUtil.getCommitLogs(commitLogDir);
        File lastModified = null;
        for (File file : files) {
            if (lastModified != null && lastModified.lastModified() >= file.lastModified()) continue;
            lastModified = file;
        }
        if (lastModified != null) {
            this.processCommitLog(lastModified);
        } else {
            LOGGER.info("No commit logs found in {}", (Object)DatabaseDescriptor.getCommitLogLocation());
        }
    }
}

