/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.CommitLogUtil;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorDataException;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;

public class OffsetPosition
implements Comparable<OffsetPosition> {
    public static final String DEFAULT_FILENAME = "";
    public static final int DEFAULT_POSITION = -1;
    public final String fileName;
    public final int filePosition;

    public OffsetPosition(String fileName, int filePosition) {
        this.fileName = fileName;
        this.filePosition = filePosition;
    }

    public String serialize() {
        return this.fileName + File.pathSeparatorChar + this.filePosition;
    }

    public static OffsetPosition parse(String offset) {
        Object[] fileAndPos = offset.split(Character.toString(File.pathSeparatorChar));
        if (fileAndPos.length != 2) {
            throw new CassandraConnectorDataException("OffsetPosition should have a file and a position, but got " + Arrays.toString(fileAndPos));
        }
        return new OffsetPosition(fileAndPos[0], Integer.parseInt(fileAndPos[1]));
    }

    public static OffsetPosition defaultOffsetPosition() {
        return new OffsetPosition(DEFAULT_FILENAME, -1);
    }

    @Override
    public int compareTo(OffsetPosition other) {
        if (this == other) {
            return 0;
        }
        int result = CommitLogUtil.compareCommitLogs(this.fileName, other.fileName);
        if (result == 0) {
            result = Integer.compare(this.filePosition, other.filePosition);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetPosition that = (OffsetPosition)o;
        return this.filePosition == that.filePosition && Objects.equals(this.fileName, that.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.filePosition);
    }

    public String toString() {
        return this.serialize();
    }
}

