/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.CassandraTypeToAvroSchemaMapper;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;

public class UserTypeDeserializer
extends TypeDeserializer {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        ByteBuffer userTypeByteBuffer = (ByteBuffer)super.deserialize(abstractType, bb);
        UserType userType = (UserType)abstractType;
        UserTypes.Value value = UserTypes.Value.fromSerialized((ByteBuffer)userTypeByteBuffer, (UserType)userType);
        List elements = value.getElements();
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(this.getSchema(abstractType));
        for (int i = 0; i < userType.fieldNames().size(); ++i) {
            String fieldName = userType.fieldNameAsString(i);
            AbstractType fieldType = userType.type(i);
            recordBuilder.set(fieldName, CassandraTypeDeserializer.deserialize(fieldType, (ByteBuffer)elements.get(i)));
        }
        return recordBuilder.build();
    }

    @Override
    public Schema getSchema(AbstractType<?> abstractType) {
        UserType userType = (UserType)abstractType;
        SchemaBuilder.FieldAssembler schemaBuilder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)userType.getNameAsString()).namespace(userType.keyspace)).fields();
        List fieldIdentifiers = userType.fieldNames();
        List fieldTypes = userType.fieldTypes();
        for (int i = 0; i < fieldIdentifiers.size(); ++i) {
            Schema fieldSchema = CassandraTypeToAvroSchemaMapper.getSchema((AbstractType)fieldTypes.get(i), false);
            schemaBuilder.name(((FieldIdentifier)fieldIdentifiers.get(i)).toString()).type(fieldSchema).noDefault();
        }
        return (Schema)schemaBuilder.endRecord();
    }
}

