/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeToAvroSchemaMapper;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;

public class MapTypeDeserializer
extends TypeDeserializer {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        Map deserializedMap = (Map)super.deserialize(abstractType, bb);
        MapType mapType = (MapType)abstractType;
        Schema keySchema = CassandraTypeToAvroSchemaMapper.getSchema(mapType.getKeysType(), false);
        if (keySchema.getType() == Schema.Type.STRING) {
            return deserializedMap;
        }
        HashMap finalMap = new HashMap(deserializedMap.size());
        for (Map.Entry entry : deserializedMap.entrySet()) {
            finalMap.put(entry.getKey().toString(), entry.getValue());
        }
        return finalMap;
    }

    @Override
    public Schema getSchema(AbstractType<?> abstractType) {
        MapType mapType = (MapType)abstractType;
        AbstractType valuesType = mapType.getValuesType();
        Schema valuesSchema = CassandraTypeToAvroSchemaMapper.getSchema(valuesType, false);
        return (Schema)SchemaBuilder.map().values(valuesSchema);
    }
}

