/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.AvroRecord;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.Module;
import io.debezium.connector.cassandra.OffsetPosition;
import io.debezium.connector.cassandra.transforms.CassandraTypeToAvroSchemaMapper;
import java.util.HashMap;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;

public class SourceInfo
implements AvroRecord {
    public static final String DEBEZIUM_VERSION_KEY = "version";
    public static final String DEBEZIUM_CONNECTOR_KEY = "connector";
    public static final String CLUSTER_KEY = "cluster";
    public static final String COMMITLOG_FILENAME_KEY = "file";
    public static final String COMMITLOG_POSITION_KEY = "pos";
    public static final String KEYSPACE_NAME_KEY = "keyspace";
    public static final String TABLE_NAME_KEY = "table";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final String TIMESTAMP_KEY = "ts_micro";
    public static final Schema SOURCE_SCHEMA = (Schema)SchemaBuilder.builder().record("source").fields().requiredString("version").requiredString("connector").requiredString("cluster").requiredString("file").requiredInt("pos").requiredBoolean("snapshot").requiredString("keyspace").requiredString("table").name("ts_micro").type(CassandraTypeToAvroSchemaMapper.TIMESTAMP_MICRO_TYPE).noDefault().endRecord();
    public final String version = Module.version();
    public final String connector = Module.name();
    public final String cluster;
    public final OffsetPosition offsetPosition;
    public final KeyspaceTable keyspaceTable;
    public final boolean snapshot;
    public final long tsMicro;

    public SourceInfo(String cluster, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable, boolean snapshot, long tsMicro) {
        this.cluster = cluster;
        this.offsetPosition = offsetPosition;
        this.keyspaceTable = keyspaceTable;
        this.tsMicro = tsMicro;
        this.snapshot = snapshot;
    }

    @Override
    public GenericRecord record(Schema schema) {
        return new GenericRecordBuilder(schema).set(DEBEZIUM_VERSION_KEY, (Object)this.version).set(DEBEZIUM_CONNECTOR_KEY, (Object)this.connector).set(CLUSTER_KEY, (Object)this.cluster).set(COMMITLOG_FILENAME_KEY, (Object)this.offsetPosition.fileName).set(COMMITLOG_POSITION_KEY, (Object)this.offsetPosition.filePosition).set(SNAPSHOT_KEY, (Object)this.snapshot).set(KEYSPACE_NAME_KEY, (Object)this.keyspaceTable.keyspace).set(TABLE_NAME_KEY, (Object)this.keyspaceTable.table).set(TIMESTAMP_KEY, (Object)this.tsMicro).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceInfo that = (SourceInfo)o;
        return this.version.equals(that.version) && this.connector.equals(that.connector) && this.cluster.equals(that.cluster) && this.offsetPosition == that.offsetPosition && this.snapshot == that.snapshot && this.keyspaceTable == that.keyspaceTable && this.tsMicro == that.tsMicro;
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.snapshot, this.offsetPosition, this.keyspaceTable, this.tsMicro);
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DEBEZIUM_VERSION_KEY, this.version);
        map.put(DEBEZIUM_CONNECTOR_KEY, this.connector);
        map.put(CLUSTER_KEY, this.cluster);
        map.put(SNAPSHOT_KEY, this.snapshot);
        map.put(COMMITLOG_FILENAME_KEY, this.offsetPosition.fileName);
        map.put(COMMITLOG_POSITION_KEY, this.offsetPosition.filePosition);
        map.put(KEYSPACE_NAME_KEY, this.keyspaceTable.keyspace);
        map.put(TABLE_NAME_KEY, this.keyspaceTable.table);
        map.put(TIMESTAMP_KEY, this.tsMicro);
        return ((Object)map).toString();
    }
}

