/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.driver.core.ColumnMetadata;
import io.debezium.connector.cassandra.AvroRecord;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.CassandraTypeToAvroSchemaMapper;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.cassandra.db.marshal.AbstractType;

public class CellData
implements AvroRecord {
    public static final String CELL_VALUE_KEY = "value";
    public static final String CELL_DELETION_TS_KEY = "deletion_ts";
    public static final String CELL_SET_KEY = "set";
    public final String name;
    public final Object value;
    public final Object deletionTs;
    public final ColumnType columnType;

    public CellData(String name, Object value, Object deletionTs, ColumnType columnType) {
        this.name = name;
        this.value = value;
        this.deletionTs = deletionTs;
        this.columnType = columnType;
    }

    public boolean isPrimary() {
        return this.columnType == ColumnType.PARTITION || this.columnType == ColumnType.CLUSTERING;
    }

    @Override
    public GenericRecord record(Schema schema) {
        return new GenericRecordBuilder(schema).set(CELL_VALUE_KEY, this.value).set(CELL_DELETION_TS_KEY, this.deletionTs).set(CELL_SET_KEY, (Object)true).build();
    }

    static Schema cellSchema(ColumnMetadata cm) {
        AbstractType<?> convertedType = CassandraTypeConverter.convert(cm.getType());
        Schema valueSchema = CassandraTypeToAvroSchemaMapper.getSchema(convertedType, true);
        if (valueSchema != null) {
            return (Schema)SchemaBuilder.builder().record(cm.getName()).fields().name(CELL_VALUE_KEY).type(valueSchema).noDefault().name(CELL_DELETION_TS_KEY).type(CassandraTypeToAvroSchemaMapper.nullable(CassandraTypeToAvroSchemaMapper.LONG_TYPE)).withDefault(null).name(CELL_SET_KEY).type().booleanType().noDefault().endRecord();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellData that = (CellData)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && this.deletionTs == that.deletionTs && this.columnType == that.columnType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.value, this.deletionTs, this.columnType});
    }

    public String toString() {
        return "{name=" + this.name + ", value=" + this.value + ", deletionTs=" + this.deletionTs + ", type=" + this.columnType.name() + '}';
    }

    public static enum ColumnType {
        PARTITION,
        CLUSTERING,
        REGULAR;

    }
}

