/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.debezium.connector.cassandra.CommitLogTransfer;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorConfigException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public class CassandraConnectorConfig {
    public static final String CONNECTOR_NAME = "connector.name";
    public static final String KAFKA_TOPIC_PREFIX = "kafka.topic.prefix";
    public static final String KAFKA_PRODUCER_CONFIG_PREFIX = "kafka.producer.";
    public static final String SNAPSHOT_MODE = "snapshot.mode";
    public static final String DEFAULT_SNAPSHOT_MODE = "INITIAL";
    public static final String SNAPSHOT_CONSISTENCY = "snapshot.consistency";
    public static final String DEFAULT_SNAPSHOT_CONSISTENCY = "QUORUM";
    public static final String HTTP_PORT = "http.port";
    public static final int DEFAULT_HTTP_PORT = 8000;
    public static final String CASSANDRA_CONFIG = "cassandra.config";
    public static final String CASSANDRA_HOSTS = "cassandra.hosts";
    public static final String DEFAULT_CASSANDRA_HOST = "localhost";
    public static final String CASSANDRA_PORT = "cassandra.port";
    public static final int DEFAULT_CASSANDRA_PORT = 9042;
    public static final String CASSANDRA_USERNAME = "cassandra.username";
    public static final String CASSANDRA_PASSWORD = "cassandra.password";
    public static final String CASSANDRA_SSL_ENABLED = "cassandra.ssl.enabled";
    public static final boolean DEFAULT_CASSANDRA_SSL_ENABLED = false;
    public static final String CASSANDRA_SSL_CONFIG_PATH = "cassandra.ssl.config.path";
    public static final String COMMIT_LOG_RELOCATION_DIR = "commit.log.relocation.dir";
    public static final String COMMIT_LOG_POST_PROCESSING_ENABLED = "commit.log.post.processing.enabled";
    public static final boolean DEFAULT_COMMIT_LOG_POST_PROCESSING_ENABLED = true;
    public static final String COMMIT_LOG_TRANSFER_CLASS = "commit.log.transfer.class";
    public static final String DEFAULT_COMMIT_LOG_TRANSFER_CLASS = "io.debezium.connector.cassandra.BlackHoleCommitLogTransfer";
    public static final String COMMIT_LOG_TRANSFER_CONFIG_PREFIX = "commit.log.transfer.";
    public static final String OFFSET_BACKING_STORE_DIR = "offset.backing.store.dir";
    public static final String OFFSET_FLUSH_INTERVAL_MS = "offset.flush.interval.ms";
    public static final int DEFAULT_OFFSET_FLUSH_INTERVAL_MS = 0;
    public static final String MAX_OFFSET_FLUSH_SIZE = "max.offset.flush.size";
    public static final int DEFAULT_MAX_OFFSET_FLUSH_SIZE = 100;
    public static final String MAX_QUEUE_SIZE = "max.queue.size";
    public static final int DEFAULT_MAX_QUEUE_SIZE = 8192;
    public static final String MAX_BATCH_SIZE = "max.batch.size";
    public static final int DEFAULT_MAX_BATCH_SIZE = 2048;
    public static final String POLL_INTERVAL_MS = "poll.interval.ms";
    public static final int DEFAULT_POLL_INTERVAL_MS = 1000;
    public static final String SCHEMA_POLL_INTERVAL_MS = "schema.refresh.interval.ms";
    public static final int DEFAULT_SCHEMA_POLL_INTERVAL_MS = 10000;
    public static final String CDC_DIR_POLL_INTERVAL_MS = "cdc.dir.poll.interval.ms";
    public static final int DEFAULT_CDC_DIR_POLL_INTERVAL_MS = 10000;
    public static final String SNAPSHOT_POLL_INTERVAL_MS = "snapshot.scan.interval.ms";
    public static final int DEFAULT_SNAPSHOT_POLL_INTERVAL_MS = 10000;
    public static final String TOMBSTONES_ON_DELETE = "tombstones.on.delete";
    public static final boolean DEFAULT_TOMBSTONES_ON_DELETE = false;
    public static final String FIELD_BLACKLIST = "field.blacklist";
    public static final String LATEST_COMMIT_LOG_ONLY = "latest.commit.log.only";
    public static final boolean DEFAULT_LATEST_COMMIT_LOG_ONLY = false;
    private Map<String, Object> configs;

    public String connectorName() {
        return (String)this.configs.get(CONNECTOR_NAME);
    }

    public String kafkaTopicPrefix() {
        return (String)this.configs.get(KAFKA_TOPIC_PREFIX);
    }

    public Properties getKafkaConfigs() {
        Properties props = new Properties();
        props.put("key.serializer", KafkaAvroSerializer.class);
        props.put("value.serializer", KafkaAvroSerializer.class);
        this.configs.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(KAFKA_PRODUCER_CONFIG_PREFIX)).forEach(entry -> {
            String k = ((String)entry.getKey()).replace(KAFKA_PRODUCER_CONFIG_PREFIX, "");
            Object v = entry.getValue();
            props.put(k, v);
        });
        return props;
    }

    public Properties commitLogTransferConfigs() {
        Properties props = new Properties();
        this.configs.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(COMMIT_LOG_TRANSFER_CONFIG_PREFIX)).forEach(entry -> props.put(entry.getKey(), entry.getValue()));
        return props;
    }

    public boolean latestCommitLogOnly() {
        return (Boolean)this.configs.getOrDefault(LATEST_COMMIT_LOG_ONLY, false);
    }

    public CassandraConnectorConfig(Map<String, Object> configs) {
        this.configs = configs;
    }

    public SnapshotMode snapshotMode() {
        String mode = (String)this.configs.getOrDefault(SNAPSHOT_MODE, DEFAULT_SNAPSHOT_MODE);
        Optional<SnapshotMode> snapshotModeOpt = SnapshotMode.fromText(mode);
        return snapshotModeOpt.orElseThrow(() -> new CassandraConnectorConfigException(mode + " is not a valid SnapshotMode"));
    }

    public ConsistencyLevel snapshotConsistencyLevel() {
        String cl = (String)this.configs.getOrDefault(SNAPSHOT_CONSISTENCY, DEFAULT_SNAPSHOT_CONSISTENCY);
        return ConsistencyLevel.valueOf((String)cl);
    }

    public int httpPort() {
        return (Integer)this.configs.getOrDefault(HTTP_PORT, 8000);
    }

    public String cassandraConfig() {
        return (String)this.configs.get(CASSANDRA_CONFIG);
    }

    public String[] cassandraHosts() {
        String hosts = (String)this.configs.getOrDefault(CASSANDRA_HOSTS, DEFAULT_CASSANDRA_HOST);
        return hosts.split(",");
    }

    public int cassandraPort() {
        return (Integer)this.configs.getOrDefault(CASSANDRA_PORT, 9042);
    }

    public boolean cassandraSslEnabled() {
        return (Boolean)this.configs.getOrDefault(CASSANDRA_SSL_ENABLED, false);
    }

    public String cassandraSslConfigPath() {
        return (String)this.configs.get(CASSANDRA_SSL_CONFIG_PATH);
    }

    public String cassandraUsername() {
        return (String)this.configs.get(CASSANDRA_USERNAME);
    }

    public String cassandraPassword() {
        return (String)this.configs.get(CASSANDRA_PASSWORD);
    }

    public String commitLogRelocationDir() {
        return (String)this.configs.get(COMMIT_LOG_RELOCATION_DIR);
    }

    public boolean postProcessEnabled() {
        return (Boolean)this.configs.getOrDefault(COMMIT_LOG_POST_PROCESSING_ENABLED, true);
    }

    public CommitLogTransfer getCommitLogTransfer() {
        try {
            String clazz = (String)this.configs.getOrDefault(COMMIT_LOG_TRANSFER_CLASS, DEFAULT_COMMIT_LOG_TRANSFER_CLASS);
            CommitLogTransfer transfer = (CommitLogTransfer)Class.forName(clazz).newInstance();
            transfer.init(this.commitLogTransferConfigs());
            return transfer;
        }
        catch (Exception e) {
            throw new CassandraConnectorConfigException(e);
        }
    }

    public String offsetBackingStoreDir() {
        return (String)this.configs.get(OFFSET_BACKING_STORE_DIR);
    }

    public Duration offsetFlushIntervalMs() {
        int ms = (Integer)this.configs.getOrDefault(OFFSET_FLUSH_INTERVAL_MS, 0);
        return Duration.ofMillis(ms);
    }

    public long maxOffsetFlushSize() {
        return ((Integer)this.configs.getOrDefault(MAX_OFFSET_FLUSH_SIZE, 100)).intValue();
    }

    public int maxQueueSize() {
        return (Integer)this.configs.getOrDefault(MAX_QUEUE_SIZE, 8192);
    }

    public int maxBatchSize() {
        return (Integer)this.configs.getOrDefault(MAX_BATCH_SIZE, 2048);
    }

    public Duration pollIntervalMs() {
        int ms = (Integer)this.configs.getOrDefault(POLL_INTERVAL_MS, 1000);
        return Duration.ofMillis(ms);
    }

    public Duration schemaPollIntervalMs() {
        int ms = (Integer)this.configs.getOrDefault(SCHEMA_POLL_INTERVAL_MS, 10000);
        return Duration.ofMillis(ms);
    }

    public Duration cdcDirPollIntervalMs() {
        int ms = (Integer)this.configs.getOrDefault(CDC_DIR_POLL_INTERVAL_MS, 10000);
        return Duration.ofMillis(ms);
    }

    public Duration snapshotPollIntervalMs() {
        int ms = (Integer)this.configs.getOrDefault(SNAPSHOT_POLL_INTERVAL_MS, 10000);
        return Duration.ofMillis(ms);
    }

    public String[] fieldBlacklist() {
        String hosts = (String)this.configs.get(FIELD_BLACKLIST);
        if (hosts == null) {
            return new String[0];
        }
        return hosts.split(",");
    }

    public boolean tombstonesOnDelete() {
        return (Boolean)this.configs.getOrDefault(TOMBSTONES_ON_DELETE, false);
    }

    public String toString() {
        return this.configs.entrySet().stream().filter(e -> !((String)e.getKey()).toLowerCase().contains("username") && !((String)e.getKey()).toLowerCase().contains("password")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).toString();
    }

    public static enum SnapshotMode {
        ALWAYS,
        INITIAL,
        NEVER;


        public static Optional<SnapshotMode> fromText(String text) {
            return Arrays.stream(SnapshotMode.values()).filter(v -> text != null && v.name().toLowerCase().equals(text.toLowerCase())).findFirst();
        }
    }
}

