/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingEventQueue<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingEventQueue.class);
    private static final int SLEEP_MS = 100;
    private final Duration pollInterval;
    private final int maxBatchSize;
    private final BlockingQueue queue;

    public BlockingEventQueue(Duration pollInterval, int maxQueueSize, int maxBatchSize) {
        this.pollInterval = pollInterval;
        this.maxBatchSize = maxBatchSize;
        this.queue = new LinkedBlockingDeque(maxQueueSize);
    }

    public void enqueue(T event) {
        try {
            this.queue.put(event);
        }
        catch (InterruptedException e) {
            LOGGER.error("Interruption while enqueuing event {}", event);
            throw new CassandraConnectorTaskException("Enqueuing has been interrupted: ", e);
        }
    }

    public List<T> poll() throws InterruptedException {
        LOGGER.debug("Begin polling events...");
        ArrayList events = new ArrayList();
        long then = System.currentTimeMillis();
        while (this.queue.drainTo(events, this.maxBatchSize) == 0) {
            Thread.sleep(100L);
            long now = System.currentTimeMillis();
            if (now - then < this.pollInterval.toMillis()) continue;
            LOGGER.debug("Polling interval exceeded, returning empty-handed...");
            break;
        }
        LOGGER.debug("Polled {} events", (Object)events.size());
        return events;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }
}

