/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.CassandraConnectorConfig;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class CassandraConnectorConfigTest {
    @Test
    public void testConfigs() {
        String connectorName = "test_connector";
        CassandraConnectorConfig config = this.buildTaskConfig("connector.name", connectorName);
        Assert.assertEquals((Object)connectorName, (Object)config.connectorName());
        String kafkaTopicPrefix = "test_prefix";
        config = this.buildTaskConfig("kafka.topic.prefix", kafkaTopicPrefix);
        Assert.assertEquals((Object)kafkaTopicPrefix, (Object)config.kafkaTopicPrefix());
        String snapshotConsistency = "ALL";
        config = this.buildTaskConfig("snapshot.consistency", snapshotConsistency);
        Assert.assertEquals((Object)snapshotConsistency, (Object)config.snapshotConsistencyLevel().name().toUpperCase());
        int port = 1234;
        config = this.buildTaskConfig("http.port", port);
        Assert.assertEquals((long)port, (long)config.httpPort());
        String cassandraConfig = "cassandra-unit.yaml";
        config = this.buildTaskConfig("cassandra.config", cassandraConfig);
        Assert.assertEquals((Object)cassandraConfig, (Object)config.cassandraConfig());
        String cassandraHosts = "127.0.0.1,127.0.0.2";
        config = this.buildTaskConfig("cassandra.hosts", cassandraHosts);
        Assert.assertArrayEquals((Object[])cassandraHosts.split(","), (Object[])config.cassandraHosts());
        int cassandraPort = 9412;
        config = this.buildTaskConfig("cassandra.port", cassandraPort);
        Assert.assertEquals((long)cassandraPort, (long)config.cassandraPort());
        String cassandraUsername = "test_user";
        config = this.buildTaskConfig("cassandra.username", cassandraUsername);
        Assert.assertEquals((Object)cassandraUsername, (Object)config.cassandraUsername());
        String cassandraPassword = "test_pw";
        config = this.buildTaskConfig("cassandra.password", cassandraPassword);
        Assert.assertEquals((Object)cassandraPassword, (Object)config.cassandraPassword());
        config = this.buildTaskConfig("cassandra.ssl.enabled", true);
        Assert.assertTrue((boolean)config.cassandraSslEnabled());
        String cassandraSslConfigPath = "/some/path/";
        config = this.buildTaskConfig("cassandra.ssl.config.path", cassandraSslConfigPath);
        Assert.assertEquals((Object)cassandraSslConfigPath, (Object)config.cassandraSslConfigPath());
        String kafkaServers = "host1,host2,host3";
        config = this.buildTaskConfig("kafka.producer.bootstrap.servers", kafkaServers);
        Assert.assertEquals((Object)kafkaServers, (Object)config.getKafkaConfigs().getProperty("bootstrap.servers"));
        String schemaRegistry = "schema-registry-host";
        config = this.buildTaskConfig("kafka.producer.schema.registry", schemaRegistry);
        Assert.assertEquals((Object)schemaRegistry, (Object)config.getKafkaConfigs().getProperty("schema.registry"));
        String offsetBackingStore = "/some/offset/backing/store/";
        config = this.buildTaskConfig("offset.backing.store.dir", offsetBackingStore);
        Assert.assertEquals((Object)offsetBackingStore, (Object)config.offsetBackingStoreDir());
        int offsetFlushIntervalMs = 1234;
        config = this.buildTaskConfig("offset.flush.interval.ms", offsetFlushIntervalMs);
        Assert.assertEquals((long)offsetFlushIntervalMs, (long)config.offsetFlushIntervalMs().toMillis());
        int offsetMaxFlushSize = 200;
        config = this.buildTaskConfig("max.offset.flush.size", offsetMaxFlushSize);
        Assert.assertEquals((long)offsetMaxFlushSize, (long)config.maxOffsetFlushSize());
        int maxQueueSize = 500;
        config = this.buildTaskConfig("max.queue.size", maxQueueSize);
        Assert.assertEquals((long)maxQueueSize, (long)config.maxQueueSize());
        int maxBatchSize = 500;
        config = this.buildTaskConfig("max.batch.size", maxBatchSize);
        Assert.assertEquals((long)maxBatchSize, (long)config.maxBatchSize());
        int pollIntervalMs = 500;
        config = this.buildTaskConfig("poll.interval.ms", pollIntervalMs);
        Assert.assertEquals((long)pollIntervalMs, (long)config.pollIntervalMs().toMillis());
        int schemaPollIntervalMs = 500;
        config = this.buildTaskConfig("schema.refresh.interval.ms", schemaPollIntervalMs);
        Assert.assertEquals((long)schemaPollIntervalMs, (long)config.schemaPollIntervalMs().toMillis());
        int cdcDirPollIntervalMs = 500;
        config = this.buildTaskConfig("cdc.dir.poll.interval.ms", cdcDirPollIntervalMs);
        Assert.assertEquals((long)cdcDirPollIntervalMs, (long)config.cdcDirPollIntervalMs().toMillis());
        int snapshotPollIntervalMs = 500;
        config = this.buildTaskConfig("snapshot.scan.interval.ms", snapshotPollIntervalMs);
        Assert.assertEquals((long)snapshotPollIntervalMs, (long)config.snapshotPollIntervalMs().toMillis());
        String fieldBlacklist = "keyspace1.table1.column1,keyspace1.table1.column2";
        config = this.buildTaskConfig("field.blacklist", fieldBlacklist);
        Assert.assertArrayEquals((Object[])fieldBlacklist.split(","), (Object[])config.fieldBlacklist());
        config = this.buildTaskConfig("tombstones.on.delete", true);
        Assert.assertTrue((boolean)config.tombstonesOnDelete());
        String snapshotMode = "always";
        config = this.buildTaskConfig("snapshot.mode", snapshotMode);
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.ALWAYS, (Object)config.snapshotMode());
        String commitLogDir = "/foo/bar";
        config = this.buildTaskConfig("commit.log.relocation.dir", commitLogDir);
        Assert.assertEquals((Object)commitLogDir, (Object)config.commitLogRelocationDir());
        boolean shouldPostProcess = false;
        config = this.buildTaskConfig("commit.log.post.processing.enabled", shouldPostProcess);
        Assert.assertEquals((Object)shouldPostProcess, (Object)config.postProcessEnabled());
        String transferClazz = "io.debezium.connector.cassandra.BlackHoleCommitLogTransfer";
        config = this.buildTaskConfig("commit.log.transfer.class", transferClazz);
        Assert.assertEquals((Object)transferClazz, (Object)config.getCommitLogTransfer().getClass().getName());
    }

    private CassandraConnectorConfig buildTaskConfig(String key, Object value) {
        Map<String, Object> map = Collections.singletonMap(key, value);
        return new CassandraConnectorConfig(map);
    }

    @Test
    public void testDefaultConfigs() {
        CassandraConnectorConfig config = new CassandraConnectorConfig(Collections.emptyMap());
        Assert.assertEquals((Object)"QUORUM", (Object)config.snapshotConsistencyLevel().name().toUpperCase());
        Assert.assertEquals((long)8000L, (long)config.httpPort());
        Assert.assertArrayEquals((Object[])"localhost".split(","), (Object[])config.cassandraHosts());
        Assert.assertEquals((long)9042L, (long)config.cassandraPort());
        Assert.assertEquals((long)8192L, (long)config.maxQueueSize());
        Assert.assertEquals((long)2048L, (long)config.maxBatchSize());
        Assert.assertEquals((long)1000L, (long)config.pollIntervalMs().toMillis());
        Assert.assertEquals((long)100L, (long)config.maxOffsetFlushSize());
        Assert.assertEquals((long)0L, (long)config.offsetFlushIntervalMs().toMillis());
        Assert.assertEquals((long)10000L, (long)config.schemaPollIntervalMs().toMillis());
        Assert.assertEquals((long)10000L, (long)config.cdcDirPollIntervalMs().toMillis());
        Assert.assertEquals((long)10000L, (long)config.snapshotPollIntervalMs().toMillis());
        Assert.assertEquals((Object)true, (Object)config.postProcessEnabled());
        Assert.assertEquals((Object)"io.debezium.connector.cassandra.BlackHoleCommitLogTransfer", (Object)config.getCommitLogTransfer().getClass().getName());
        Assert.assertFalse((boolean)config.cassandraSslEnabled());
        Assert.assertFalse((boolean)config.tombstonesOnDelete());
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.INITIAL, (Object)config.snapshotMode());
    }

    @Test
    public void testSnapshotMode() {
        String mode = "initial";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.INITIAL, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = "INITIAL";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.INITIAL, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = "Initial";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.INITIAL, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = "always";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.ALWAYS, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = "never";
        Assert.assertEquals((Object)CassandraConnectorConfig.SnapshotMode.NEVER, CassandraConnectorConfig.SnapshotMode.fromText((String)mode).get());
        mode = null;
        Assert.assertFalse((boolean)CassandraConnectorConfig.SnapshotMode.fromText((String)mode).isPresent());
        mode = "";
        Assert.assertFalse((boolean)CassandraConnectorConfig.SnapshotMode.fromText((String)mode).isPresent());
        mode = "invalid";
        Assert.assertFalse((boolean)CassandraConnectorConfig.SnapshotMode.fromText((String)mode).isPresent());
    }
}

