/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.CassandraPrincipal;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraLoginModule
implements LoginModule {
    private static final Logger logger = LoggerFactory.getLogger(CassandraLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private CassandraPrincipal principal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            logger.info("No CallbackHandler available for authentication");
            throw new LoginException("Authentication failed");
        }
        NameCallback nc = new NameCallback("username: ");
        PasswordCallback pc = new PasswordCallback("password: ", false);
        try {
            this.callbackHandler.handle(new Callback[]{nc, pc});
            this.username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            pc.clearPassword();
        }
        catch (IOException | UnsupportedCallbackException e) {
            logger.info("Unexpected exception processing authentication callbacks", (Throwable)e);
            throw new LoginException("Authentication failed");
        }
        try {
            this.authenticate();
        }
        catch (AuthenticationException e) {
            this.succeeded = false;
            this.cleanUpInternalState();
            throw new FailedLoginException(e.getMessage());
        }
        this.succeeded = true;
        return true;
    }

    private void authenticate() {
        if (!StorageService.instance.isAuthSetupComplete()) {
            throw new AuthenticationException("Cannot login as server authentication setup is not yet completed");
        }
        IAuthenticator authenticator = DatabaseDescriptor.getAuthenticator();
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", this.username);
        credentials.put("password", String.valueOf(this.password));
        AuthenticatedUser user = authenticator.legacyAuthenticate(credentials);
        if (user.isAnonymous() || user.isSystem()) {
            throw new AuthenticationException(String.format("Invalid user %s", user.getName()));
        }
        if (!DatabaseDescriptor.getRoleManager().canLogin(user.getPrimaryRole())) {
            throw new AuthenticationException(user.getName() + " is not permitted to log in");
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.principal = new CassandraPrincipal(this.username);
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.cleanUpInternalState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (!this.commitSucceeded) {
            this.succeeded = false;
            this.cleanUpInternalState();
            this.principal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.succeeded = false;
        this.cleanUpInternalState();
        this.principal = null;
        return true;
    }

    private void cleanUpInternalState() {
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
    }
}

