/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeToAvroSchemaMapper;
import io.debezium.connector.cassandra.transforms.UuidUtil;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.cassandra.db.marshal.AbstractType;

public class TimeUUIDTypeDeserializer
extends TypeDeserializer {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        Object value = super.deserialize(abstractType, bb);
        byte[] bytes = UuidUtil.asBytes((UUID)value);
        return new GenericData.Fixed(CassandraTypeToAvroSchemaMapper.UUID_TYPE, bytes);
    }

    @Override
    public Schema getSchema(AbstractType<?> abstractType) {
        return CassandraTypeToAvroSchemaMapper.UUID_TYPE;
    }
}

