/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeToAvroSchemaMapper;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;

public class ListTypeDeserializer
extends TypeDeserializer {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        List deserializedList = (List)super.deserialize(abstractType, bb);
        return new GenericData.Array(this.getSchema(abstractType), (Collection)deserializedList);
    }

    @Override
    public Schema getSchema(AbstractType<?> abstractType) {
        ListType listType = (ListType)abstractType;
        AbstractType elementsType = listType.getElementsType();
        Schema innerSchema = CassandraTypeToAvroSchemaMapper.getSchema(elementsType, false);
        return (Schema)SchemaBuilder.array().items(innerSchema);
    }
}

