/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeToAvroSchemaMapper;
import io.debezium.connector.cassandra.transforms.type.deserializer.BasicTypeDeserializer;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.db.marshal.AbstractType;

public class DurationTypeDeserializer
extends BasicTypeDeserializer {
    public DurationTypeDeserializer() {
        super(CassandraTypeToAvroSchemaMapper.DURATION_TYPE);
    }

    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        Duration duration = (Duration)super.deserialize(abstractType, bb);
        int months = duration.getMonths();
        int days = duration.getDays();
        long nanoSec = duration.getNanoseconds();
        Schema durationSchema = this.getSchema(abstractType);
        return new GenericRecordBuilder(durationSchema).set("months", (Object)months).set("days", (Object)days).set("nanos", (Object)nanoSec).build();
    }
}

